/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.CandicornEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class CandicornModel
extends AdvancedEntityModel<CandicornEntity> {
    private final AdvancedModelBox main;
    private final AdvancedModelBox body;
    private final AdvancedModelBox tail1;
    private final AdvancedModelBox tail2;
    private final AdvancedModelBox saddle;
    private final AdvancedModelBox head;
    private final AdvancedModelBox saddle_head;
    private final AdvancedModelBox left_Rein;
    private final AdvancedModelBox right_Rein;
    private final AdvancedModelBox mane1;
    private final AdvancedModelBox mane2;
    private final AdvancedModelBox mane3;
    private final AdvancedModelBox left_headTuft;
    private final AdvancedModelBox right_headTuft;
    private final AdvancedModelBox left_Ear;
    private final AdvancedModelBox right_Ear;
    private final AdvancedModelBox horn;
    private final AdvancedModelBox left_frontLeg;
    private final AdvancedModelBox right_frontLeg;
    private final AdvancedModelBox right_backLeg;
    private final AdvancedModelBox left_backLeg;
    private final AdvancedModelBox cube_r1;
    private final AdvancedModelBox cube_r2;
    private final AdvancedModelBox cube_r3;
    private final AdvancedModelBox cube_r4;
    private final AdvancedModelBox cube_r5;
    private final ModelAnimator animator;

    public CandicornModel() {
        this.texWidth = 128;
        this.texHeight = 128;
        this.main = new AdvancedModelBox((AdvancedEntityModel)this);
        this.main.setRotationPoint(0.0f, 24.0f, 0.0f);
        this.body = new AdvancedModelBox((AdvancedEntityModel)this);
        this.body.setRotationPoint(0.0f, -20.75f, 0.0f);
        this.main.addChild((BasicModelPart)this.body);
        this.body.setTextureOffset(0, 39).addBox(-5.0f, -7.25f, -11.0f, 10.0f, 12.0f, 22.0f, 0.0f, false);
        this.body.setTextureOffset(0, 0).addBox(-5.0f, -7.25f, -11.0f, 10.0f, 17.0f, 22.0f, 0.25f, false);
        this.tail1 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tail1.setRotationPoint(0.0f, -6.75f, 10.5f);
        this.body.addChild((BasicModelPart)this.tail1);
        this.tail1.setTextureOffset(47, 56).addBox(-3.5f, -3.5f, 0.5f, 7.0f, 7.0f, 17.0f, 0.0f, false);
        this.tail2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tail2.setRotationPoint(0.0f, 0.0f, 17.0f);
        this.tail1.addChild((BasicModelPart)this.tail2);
        this.tail2.setTextureOffset(47, 22).addBox(-3.5f, -3.5f, 0.5f, 7.0f, 7.0f, 17.0f, 0.01f, false);
        this.saddle = new AdvancedModelBox((AdvancedEntityModel)this);
        this.saddle.setRotationPoint(0.0f, -7.75f, 0.0f);
        this.body.addChild((BasicModelPart)this.saddle);
        this.saddle.setTextureOffset(42, 0).addBox(-5.0f, 0.5f, -5.0f, 10.0f, 11.0f, 10.0f, 0.5f, false);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.head.setRotationPoint(0.0f, -6.4846f, -9.8478f);
        this.body.addChild((BasicModelPart)this.head);
        this.setRotateAngle(this.head, 0.3927f, 0.0f, 0.0f);
        this.head.setTextureOffset(24, 73).addBox(-3.0f, -16.0f, -4.0f, 6.0f, 6.0f, 8.0f, 0.0f, false);
        this.head.setTextureOffset(0, 73).addBox(-2.0f, -10.0f, -4.0f, 4.0f, 17.0f, 8.0f, 0.0f, false);
        this.head.setTextureOffset(0, 0).addBox(-2.0f, -16.0f, -11.0f, 4.0f, 6.0f, 7.0f, 0.0f, false);
        this.saddle_head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.saddle_head.setRotationPoint(0.0f, 2.0f, 0.0f);
        this.head.addChild((BasicModelPart)this.saddle_head);
        this.saddle_head.setTextureOffset(0, 0).addBox(-3.0f, -15.0f, -9.0f, 1.0f, 2.0f, 2.0f, 0.0f, true);
        this.saddle_head.setTextureOffset(0, 13).addBox(-2.0f, -18.0f, -7.0f, 4.0f, 6.0f, 3.0f, 0.25f, false);
        this.saddle_head.setTextureOffset(0, 0).addBox(2.0f, -15.0f, -9.0f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.saddle_head.setTextureOffset(100, 92).addBox(-3.0f, -18.0f, -4.0f, 6.0f, 6.0f, 8.0f, 0.25f, false);
        this.left_Rein = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_Rein.setRotationPoint(3.0f, -14.0f, -8.0f);
        this.saddle_head.addChild((BasicModelPart)this.left_Rein);
        this.cube_r1 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r1.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.left_Rein.addChild((BasicModelPart)this.cube_r1);
        this.setRotateAngle(this.cube_r1, -0.3927f, 0.1309f, 0.0f);
        this.cube_r1.setTextureOffset(73, 105).addBox(0.025f, -2.5006f, 0.0015f, 0.0f, 5.0f, 18.0f, 0.0f, false);
        this.right_Rein = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_Rein.setRotationPoint(-3.0f, -14.0f, -8.0f);
        this.saddle_head.addChild((BasicModelPart)this.right_Rein);
        this.cube_r2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r2.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.right_Rein.addChild((BasicModelPart)this.cube_r2);
        this.setRotateAngle(this.cube_r2, -0.3927f, -0.1309f, 0.0f);
        this.cube_r2.setTextureOffset(73, 105).addBox(-0.025f, -2.5006f, 0.0015f, 0.0f, 5.0f, 18.0f, 0.0f, true);
        this.mane1 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.mane1.setRotationPoint(0.0f, -7.0f, 4.0f);
        this.head.addChild((BasicModelPart)this.mane1);
        this.mane1.setTextureOffset(0, 102).addBox(0.0f, -9.0f, 0.0f, 0.0f, 18.0f, 8.0f, 0.0f, false);
        this.mane2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.mane2.setRotationPoint(0.0f, 0.0f, 8.0f);
        this.mane1.addChild((BasicModelPart)this.mane2);
        this.mane2.setTextureOffset(38, 102).addBox(0.0f, -9.0f, 0.0f, 0.0f, 18.0f, 8.0f, 0.0f, true);
        this.mane3 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.mane3.setRotationPoint(0.0f, 0.0f, 8.0f);
        this.mane2.addChild((BasicModelPart)this.mane3);
        this.mane3.setTextureOffset(20, 102).addBox(0.0f, -9.0f, 0.0f, 0.0f, 18.0f, 8.0f, 0.0f, false);
        this.left_headTuft = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_headTuft.setRotationPoint(3.0f, -13.5f, 3.0f);
        this.head.addChild((BasicModelPart)this.left_headTuft);
        this.cube_r3 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r3.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.left_headTuft.addChild((BasicModelPart)this.cube_r3);
        this.setRotateAngle(this.cube_r3, 0.0f, -0.7854f, 0.0f);
        this.cube_r3.setTextureOffset(42, 0).addBox(0.0f, -2.5f, 0.0f, 5.0f, 8.0f, 0.0f, 0.0f, false);
        this.right_headTuft = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_headTuft.setRotationPoint(-3.0f, -13.5f, 3.0f);
        this.head.addChild((BasicModelPart)this.right_headTuft);
        this.cube_r4 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r4.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.right_headTuft.addChild((BasicModelPart)this.cube_r4);
        this.setRotateAngle(this.cube_r4, 0.0f, 0.7854f, 0.0f);
        this.cube_r4.setTextureOffset(42, 0).addBox(-5.0f, -2.5f, 0.0f, 5.0f, 8.0f, 0.0f, 0.0f, true);
        this.left_Ear = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_Ear.setRotationPoint(2.0f, -16.0f, 3.5f);
        this.head.addChild((BasicModelPart)this.left_Ear);
        this.left_Ear.setTextureOffset(15, 0).addBox(-1.0f, -3.0f, -0.5f, 2.0f, 3.0f, 1.0f, 0.0f, false);
        this.right_Ear = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_Ear.setRotationPoint(-2.0f, -16.0f, 3.5f);
        this.head.addChild((BasicModelPart)this.right_Ear);
        this.right_Ear.setTextureOffset(15, 0).addBox(-1.0f, -3.0f, -0.5f, 2.0f, 3.0f, 1.0f, 0.0f, true);
        this.horn = new AdvancedModelBox((AdvancedEntityModel)this);
        this.horn.setRotationPoint(0.0f, -16.0f, -3.0f);
        this.head.addChild((BasicModelPart)this.horn);
        this.horn.setTextureOffset(52, 74).addBox(0.0f, -12.0f, -3.0f, 0.0f, 12.0f, 6.0f, 0.0f, false);
        this.cube_r5 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r5.setRotationPoint(0.0f, -6.0f, 0.0f);
        this.horn.addChild((BasicModelPart)this.cube_r5);
        this.setRotateAngle(this.cube_r5, 0.0f, 1.5708f, 0.0f);
        this.cube_r5.setTextureOffset(42, 40).addBox(0.0f, -6.0f, -3.0f, 0.0f, 12.0f, 6.0f, 0.0f, false);
        this.left_frontLeg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_frontLeg.setRotationPoint(3.5f, 4.75f, -9.0f);
        this.body.addChild((BasicModelPart)this.left_frontLeg);
        this.left_frontLeg.setTextureOffset(14, 9).addBox(1.5f, 6.0f, 2.0f, 0.0f, 8.0f, 4.0f, 0.0f, false);
        this.left_frontLeg.setTextureOffset(0, 39).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 16.0f, 4.0f, 0.0f, false);
        this.right_frontLeg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_frontLeg.setRotationPoint(-3.5f, 4.75f, -9.0f);
        this.body.addChild((BasicModelPart)this.right_frontLeg);
        this.right_frontLeg.setTextureOffset(14, 9).addBox(-1.5f, 6.0f, 2.0f, 0.0f, 8.0f, 4.0f, 0.0f, false);
        this.right_frontLeg.setTextureOffset(0, 39).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 16.0f, 4.0f, 0.0f, true);
        this.right_backLeg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_backLeg.setRotationPoint(-3.5f, 4.75f, 9.0f);
        this.body.addChild((BasicModelPart)this.right_backLeg);
        this.right_backLeg.setTextureOffset(14, 9).addBox(-1.5f, 6.0f, 2.0f, 0.0f, 8.0f, 4.0f, 0.0f, true);
        this.right_backLeg.setTextureOffset(0, 39).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 16.0f, 4.0f, 0.0f, true);
        this.left_backLeg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_backLeg.setRotationPoint(-3.5f, 4.75f, 9.0f);
        this.body.addChild((BasicModelPart)this.left_backLeg);
        this.left_backLeg.setTextureOffset(14, 9).addBox(8.5f, 6.0f, 2.0f, 0.0f, 8.0f, 4.0f, 0.0f, false);
        this.left_backLeg.setTextureOffset(0, 39).addBox(5.5f, 0.0f, -2.0f, 3.0f, 16.0f, 4.0f, 0.0f, false);
        this.updateDefaultPose();
        this.animator = ModelAnimator.create();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.main);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.main, (Object)this.body, (Object)this.head, (Object)this.tail1, (Object)this.tail2, (Object)this.left_frontLeg, (Object)this.left_backLeg, (Object)this.left_Ear, (Object)this.right_frontLeg, (Object)this.right_backLeg, (Object)this.right_Ear, (Object)this.left_Rein, (Object[])new AdvancedModelBox[]{this.left_headTuft, this.right_Rein, this.right_headTuft, this.saddle, this.saddle_head, this.horn, this.mane1, this.mane2, this.mane3, this.cube_r1, this.cube_r2, this.cube_r3, this.cube_r4, this.cube_r5});
    }

    public void animate(IAnimatedEntity entity) {
        this.animator.update(entity);
        this.animator.setAnimation(CandicornEntity.ANIMATION_BUCK);
        this.animator.startKeyframe(5);
        this.poseBucking();
        this.animator.rotate(this.left_frontLeg, (float)Math.toRadians(-75.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_frontLeg, (float)Math.toRadians(-25.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(3);
        this.poseBucking();
        this.animator.rotate(this.left_frontLeg, (float)Math.toRadians(-25.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_frontLeg, (float)Math.toRadians(-75.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(3);
        this.poseBucking();
        this.animator.rotate(this.left_frontLeg, (float)Math.toRadians(-75.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_frontLeg, (float)Math.toRadians(-25.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(3);
        this.poseBucking();
        this.animator.rotate(this.left_frontLeg, (float)Math.toRadians(-25.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_frontLeg, (float)Math.toRadians(-75.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(3);
        this.poseBucking();
        this.animator.rotate(this.left_frontLeg, (float)Math.toRadians(-75.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_frontLeg, (float)Math.toRadians(-25.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(3);
        this.poseBucking();
        this.animator.rotate(this.left_frontLeg, (float)Math.toRadians(-25.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_frontLeg, (float)Math.toRadians(-75.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(CandicornEntity.ANIMATION_TAIL_FLICK_1);
        this.animator.startKeyframe(3);
        this.animator.rotate(this.tail1, (float)Math.toRadians(25.0), (float)Math.toRadians(25.0), 0.0f);
        this.animator.rotate(this.tail2, (float)Math.toRadians(-10.0), (float)Math.toRadians(45.0), 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(6);
        this.animator.rotate(this.tail1, (float)Math.toRadians(25.0), (float)Math.toRadians(-25.0), 0.0f);
        this.animator.rotate(this.tail2, (float)Math.toRadians(-10.0), (float)Math.toRadians(-45.0), 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(3);
        this.animator.setAnimation(CandicornEntity.ANIMATION_TAIL_FLICK_2);
        this.animator.startKeyframe(3);
        this.animator.rotate(this.tail1, (float)Math.toRadians(25.0), (float)Math.toRadians(-25.0), 0.0f);
        this.animator.rotate(this.tail2, (float)Math.toRadians(-10.0), (float)Math.toRadians(-45.0), 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(6);
        this.animator.rotate(this.tail1, (float)Math.toRadians(25.0), (float)Math.toRadians(25.0), 0.0f);
        this.animator.rotate(this.tail2, (float)Math.toRadians(-10.0), (float)Math.toRadians(45.0), 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(3);
        this.animator.setAnimation(CandicornEntity.ANIMATION_NIBBLE_IDLE);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.head, (float)Math.toRadians(100.0), 0.0f, 0.0f);
        this.animator.rotate(this.mane1, (float)Math.toRadians(-40.0), 0.0f, 0.0f);
        this.animator.move(this.head, 0.0f, 8.0f, -4.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.head, (float)Math.toRadians(90.0), 0.0f, 0.0f);
        this.animator.rotate(this.mane1, (float)Math.toRadians(-40.0), 0.0f, 0.0f);
        this.animator.move(this.head, 0.0f, 7.0f, -3.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.head, (float)Math.toRadians(100.0), 0.0f, 0.0f);
        this.animator.rotate(this.mane1, (float)Math.toRadians(-40.0), 0.0f, 0.0f);
        this.animator.move(this.head, 0.0f, 8.0f, -4.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.head, (float)Math.toRadians(90.0), 0.0f, 0.0f);
        this.animator.rotate(this.mane1, (float)Math.toRadians(-40.0), 0.0f, 0.0f);
        this.animator.move(this.head, 0.0f, 7.0f, -3.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.head, (float)Math.toRadians(100.0), 0.0f, 0.0f);
        this.animator.rotate(this.mane1, (float)Math.toRadians(-40.0), 0.0f, 0.0f);
        this.animator.move(this.head, 0.0f, 8.0f, -4.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.head, (float)Math.toRadians(90.0), 0.0f, 0.0f);
        this.animator.rotate(this.mane1, (float)Math.toRadians(-40.0), 0.0f, 0.0f);
        this.animator.move(this.head, 0.0f, 7.0f, -3.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(CandicornEntity.ANIMATION_STAB);
        this.animator.startKeyframe(5);
        this.poseBucking();
        this.animator.rotate(this.left_frontLeg, (float)Math.toRadians(35.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_frontLeg, (float)Math.toRadians(35.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-35.0), 0.0f, 0.0f);
        this.animator.rotate(this.mane1, (float)Math.toRadians(35.0), 0.0f, 0.0f);
        this.animator.move(this.body, 0.0f, 0.0f, 8.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(2);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.head, (float)Math.toRadians(75.0), 0.0f, 0.0f);
        this.animator.rotate(this.mane1, (float)Math.toRadians(-35.0), 0.0f, 0.0f);
        this.animator.move(this.body, 0.0f, 0.0f, -4.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.resetKeyframe(8);
    }

    private void poseBucking() {
        this.animator.rotate(this.body, (float)Math.toRadians(-35.0), 0.0f, 0.0f);
        this.animator.move(this.body, 0.0f, -3.0f, 3.0f);
        this.animator.move(this.left_backLeg, 0.0f, -1.5f, 0.0f);
        this.animator.move(this.right_backLeg, 0.0f, -1.5f, 0.0f);
        this.animator.rotate(this.tail1, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.animator.rotate(this.left_backLeg, (float)Math.toRadians(35.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_backLeg, (float)Math.toRadians(35.0), 0.0f, 0.0f);
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        boolean bl = this.horn.showModel = !this.f_102610_;
        if (this.f_102610_) {
            float f = 1.35f;
            this.head.setScale(f, f, f);
            this.head.setShouldScaleChildren(true);
            this.right_backLeg.setScale(1.0f, 1.5f, 1.0f);
            this.left_backLeg.setScale(1.0f, 1.5f, 1.0f);
            this.right_frontLeg.setScale(1.0f, 1.5f, 1.0f);
            this.left_frontLeg.setScale(1.0f, 1.5f, 1.0f);
            matrixStackIn.m_85836_();
            matrixStackIn.m_85841_(0.45f, 0.45f, 0.45f);
            matrixStackIn.m_85837_(0.0, 1.25, 0.125);
            this.parts().forEach(p_228292_8_ -> p_228292_8_.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            matrixStackIn.m_85849_();
            this.head.setScale(1.0f, 1.0f, 1.0f);
            this.right_backLeg.setScale(1.0f, 1.0f, 1.0f);
            this.left_backLeg.setScale(1.0f, 1.0f, 1.0f);
            this.right_frontLeg.setScale(1.0f, 1.0f, 1.0f);
            this.left_frontLeg.setScale(1.0f, 1.0f, 1.0f);
        } else {
            matrixStackIn.m_85836_();
            this.parts().forEach(p_228290_8_ -> p_228290_8_.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            matrixStackIn.m_85849_();
        }
    }

    public void setupAnim(CandicornEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        this.animate(entity);
        boolean saddled = entity.m_6254_();
        float partialTicks = ageInTicks - (float)entity.f_19797_;
        float runProgress = entity.getRunProgress(partialTicks);
        float leapProgress = entity.getLeapProgress(partialTicks);
        float runAmount = limbSwingAmount * runProgress * (1.0f - leapProgress);
        float walkProgress = 1.0f - runProgress;
        float walkAmount = limbSwingAmount * walkProgress * (1.0f - leapProgress);
        float stillAmount = 1.0f - limbSwingAmount;
        float sitProgress = entity.getSitProgress(partialTicks);
        float chargeProgress = entity.getChargeProgress(partialTicks);
        float maneWrapDirection = entity.getManeAngle(partialTicks);
        float maneWrapProgress = entity.getVehicleProgress(partialTicks);
        float walkSpeed = 0.8f;
        float walkDegree = 1.0f;
        float runSpeed = 0.5f;
        float runDegree = 1.0f;
        float headYawAmount = netHeadYaw / 57.295776f;
        float headPitchAmount = headPitch / 57.295776f;
        float yaw = entity.f_20884_ + (entity.f_20883_ - entity.f_20884_) * partialTicks;
        float tailYaw = Mth.m_14177_((float)(entity.getTailYaw(partialTicks) - yaw)) / 57.295776f;
        float leapPitch = entity.getLeapPitch(partialTicks) / 57.295776f * leapProgress;
        this.saddle.showModel = saddled;
        boolean bl = this.saddle_head.showModel = saddled && entity.m_20160_();
        this.mane1.showModel = entity.m_20160_() && Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_20365_((Entity)entity) && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() ? false : !this.f_102610_;
        this.horn.setScale(1.0f, 1.0f + chargeProgress * 0.35f, 1.0f);
        this.progressRotationPrev(this.tail1, stillAmount, (float)Math.toRadians(-65.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.tail2, stillAmount, (float)Math.toRadians(35.0), 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.tail2, stillAmount, 0.0f, 1.0f, -2.0f, 1.0f);
        this.progressRotationPrev(this.mane1, stillAmount, (float)Math.toRadians(-20.0), 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.mane1, Math.max(stillAmount, runAmount), 0.0f, -1.0f, -3.0f, 1.0f);
        this.progressRotationPrev(this.mane1, maneWrapProgress, (float)Math.toRadians(15.0), (float)Math.toRadians(-65.0f * maneWrapDirection), 0.0f, 1.0f);
        this.progressRotationPrev(this.mane2, maneWrapProgress, 0.0f, (float)Math.toRadians(35.0f * maneWrapDirection), 0.0f, 1.0f);
        this.progressRotationPrev(this.mane3, maneWrapProgress, 0.0f, (float)Math.toRadians(25.0f * maneWrapDirection), 0.0f, 1.0f);
        this.progressRotationPrev(this.left_backLeg, sitProgress, (float)Math.toRadians(-90.0), (float)Math.toRadians(-10.0), 0.0f, 1.0f);
        this.progressPositionPrev(this.left_backLeg, sitProgress, 1.0f, 1.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.right_backLeg, sitProgress, (float)Math.toRadians(-90.0), (float)Math.toRadians(10.0), 0.0f, 1.0f);
        this.progressPositionPrev(this.right_backLeg, sitProgress, -1.0f, 1.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.left_frontLeg, sitProgress, (float)Math.toRadians(-90.0), (float)Math.toRadians(-15.0), 0.0f, 1.0f);
        this.progressPositionPrev(this.left_frontLeg, sitProgress, -1.0f, 1.0f, 5.0f, 1.0f);
        this.progressRotationPrev(this.right_frontLeg, sitProgress, (float)Math.toRadians(-90.0), (float)Math.toRadians(15.0), 0.0f, 1.0f);
        this.progressPositionPrev(this.right_frontLeg, sitProgress, 1.0f, 1.0f, 5.0f, 1.0f);
        this.progressPositionPrev(this.body, sitProgress, 0.0f, 13.0f, 5.0f, 1.0f);
        this.progressRotationPrev(this.tail1, sitProgress, (float)Math.toRadians(20.0), (float)Math.toRadians(-55.0), 0.0f, 1.0f);
        this.progressRotationPrev(this.tail2, sitProgress, (float)Math.toRadians(25.0), (float)Math.toRadians(-55.0), (float)Math.toRadians(-45.0), 1.0f);
        this.progressPositionPrev(this.tail2, sitProgress, 1.0f, -1.0f, -1.0f, 1.0f);
        this.progressRotationPrev(this.head, chargeProgress, (float)Math.toRadians(50.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.horn, chargeProgress, (float)Math.toRadians(10.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.mane1, chargeProgress, (float)Math.toRadians(-10.0), 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.horn, chargeProgress, 0.0f, 0.5f, 0.5f, 1.0f);
        this.walk(this.head, 0.06f, 0.05f, true, 1.0f, -0.1f, ageInTicks, 1.0f);
        this.walk(this.mane1, 0.06f, 0.05f, false, 2.0f, -0.1f, ageInTicks, 1.0f);
        this.swing(this.mane1, 0.06f, 0.1f, false, 0.0f, 0.0f, ageInTicks, stillAmount);
        this.swing(this.mane2, 0.06f, 0.2f, false, -1.0f, 0.0f, ageInTicks, stillAmount);
        this.swing(this.mane3, 0.06f, 0.3f, false, -2.0f, 0.0f, ageInTicks, stillAmount);
        this.swing(this.tail1, 0.06f, 0.1f, false, 1.0f, 0.0f, ageInTicks, 1.0f);
        this.walk(this.tail2, 0.06f, 0.1f, false, 2.0f, 0.0f, ageInTicks, 1.0f);
        this.walk(this.left_backLeg, walkSpeed, walkDegree, false, 1.0f, 0.0f, limbSwing, walkAmount);
        this.left_backLeg.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, walkAmount, walkSpeed, -0.5f, walkDegree * 5.0f, true));
        this.walk(this.right_backLeg, walkSpeed, walkDegree, true, 1.0f, 0.0f, limbSwing, walkAmount);
        this.right_backLeg.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, walkAmount, walkSpeed, -0.5f, walkDegree * 5.0f, false));
        this.walk(this.left_frontLeg, walkSpeed, walkDegree, false, 2.5f, 0.0f, limbSwing, walkAmount);
        this.left_frontLeg.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, walkAmount, walkSpeed, 1.0f, walkDegree * 5.0f, true));
        this.walk(this.right_frontLeg, walkSpeed, walkDegree, true, 2.5f, 0.0f, limbSwing, walkAmount);
        this.right_frontLeg.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, walkAmount, walkSpeed, 1.0f, walkDegree * 5.0f, false));
        this.walk(this.tail1, walkSpeed, walkDegree * 0.2f, false, 2.0f, -0.3f, limbSwing, walkAmount);
        this.walk(this.tail2, walkSpeed, walkDegree * 0.2f, false, 1.0f, 0.1f, limbSwing, walkAmount);
        this.walk(this.head, walkSpeed, walkDegree * 0.1f, false, 2.0f, 0.0f, limbSwing, walkAmount);
        this.walk(this.mane1, walkSpeed, walkDegree * 0.1f, false, 1.0f, -0.1f, limbSwing, walkAmount);
        this.swing(this.mane1, walkSpeed, walkDegree * 0.2f, false, 0.0f, 0.0f, limbSwing, walkAmount);
        this.swing(this.mane2, walkSpeed, walkDegree * 0.3f, false, -1.0f, 0.0f, limbSwing, walkAmount);
        this.swing(this.mane3, walkSpeed, walkDegree * 0.4f, false, -2.0f, 0.0f, limbSwing, walkAmount);
        float bodyWalkBob = Math.max(0.0f, ACMath.walkValue(limbSwing, walkAmount, walkSpeed * 2.0f, -2.0f, 1.0f, false));
        float bodyRunBob = Math.min(0.0f, ACMath.walkValue(limbSwing, runAmount, runSpeed, -3.0f, 5.0f, true));
        this.body.rotationPointY += bodyWalkBob + bodyRunBob;
        this.left_frontLeg.rotationPointY -= bodyWalkBob;
        this.right_frontLeg.rotationPointY -= bodyWalkBob;
        this.left_backLeg.rotationPointY -= bodyWalkBob;
        this.right_backLeg.rotationPointY -= bodyWalkBob;
        this.walk(this.left_backLeg, runSpeed, runDegree, false, 3.0f, 0.2f, limbSwing, runAmount);
        this.left_backLeg.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, runAmount, runSpeed, 1.5f, runDegree * 5.0f, true));
        this.walk(this.right_backLeg, runSpeed, runDegree, false, 4.0f, 0.2f, limbSwing, runAmount);
        this.right_backLeg.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, runAmount, runSpeed, 2.5f, runDegree * 5.0f, true));
        this.walk(this.left_frontLeg, runSpeed, runDegree, false, 2.0f, -0.2f, limbSwing, runAmount);
        this.left_frontLeg.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, runAmount, runSpeed, 0.5f, runDegree * 5.0f, true));
        this.walk(this.right_frontLeg, runSpeed, runDegree, false, 1.0f, -0.2f, limbSwing, runAmount);
        this.right_frontLeg.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, runAmount, runSpeed, -0.5f, runDegree * 5.0f, true));
        this.walk(this.body, runSpeed, runDegree * 0.15f, false, 0.0f, 0.0f, limbSwing, runAmount);
        this.walk(this.left_backLeg, runSpeed, runDegree * 0.15f, true, 0.0f, 0.0f, limbSwing, runAmount);
        this.walk(this.right_backLeg, runSpeed, runDegree * 0.15f, true, 0.0f, 0.0f, limbSwing, runAmount);
        this.walk(this.left_frontLeg, runSpeed, runDegree * 0.15f, true, 0.0f, 0.0f, limbSwing, runAmount);
        this.walk(this.right_frontLeg, runSpeed, runDegree * 0.15f, true, 0.0f, 0.0f, limbSwing, runAmount);
        this.walk(this.tail1, runSpeed, runDegree * 0.35f, false, -1.0f, 0.0f, limbSwing, runAmount);
        this.walk(this.tail2, runSpeed, runDegree * 0.35f, false, -2.0f, 0.0f, limbSwing, runAmount);
        this.walk(this.head, runSpeed, runDegree * 0.15f, false, -1.0f, 0.2f, limbSwing, runAmount);
        this.walk(this.mane1, runSpeed, runDegree * 0.1f, false, -1.0f, -0.2f, limbSwing, runAmount);
        this.swing(this.mane1, runSpeed, runDegree * 0.2f, false, 5.0f, 0.0f, limbSwing, runAmount);
        this.swing(this.mane2, runSpeed, runDegree * 0.3f, false, 4.0f, 0.0f, limbSwing, runAmount);
        this.swing(this.mane3, runSpeed, runDegree * 0.4f, false, 3.0f, 0.0f, limbSwing, runAmount);
        this.head.rotateAngleY += headYawAmount * 0.5f;
        this.mane1.rotateAngleY += headYawAmount * -0.5f;
        this.head.rotateAngleX += headPitchAmount * 0.5f;
        this.walk(this.left_backLeg, 0.3f, 0.2f, false, 3.0f, 0.8f, ageInTicks, leapProgress);
        this.walk(this.right_backLeg, 0.3f, 0.2f, true, 2.0f, -0.8f, ageInTicks, leapProgress);
        this.walk(this.left_frontLeg, 0.3f, 0.2f, false, 1.0f, -0.8f, ageInTicks, leapProgress);
        this.walk(this.right_frontLeg, 0.3f, 0.2f, true, 0.0f, 0.8f, ageInTicks, leapProgress);
        this.tail1.rotateAngleY += tailYaw * 0.8f;
        this.body.rotateAngleX += leapPitch;
    }

    public void translateToSaddle(PoseStack translationStack) {
        this.main.translateAndRotate(translationStack);
        this.body.translateAndRotate(translationStack);
        this.saddle.translateAndRotate(translationStack);
    }
}

