/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.models.bbmodel;

import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelParts;
import com.razz.decocraft.models.bbmodel.BlockbenchBakery;
import com.razz.decocraft.models.bbmodel.BlockbenchLoader;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.SimpleUnbakedGeometry;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;

public class BlockbenchModel
extends SimpleUnbakedGeometry<BlockbenchModel> {
    private final BlockbenchBakery BAKERY = new BlockbenchBakery();
    private final BlockbenchLoader.BlockbenchSetting settings;
    private final List<BBModelParts.Element> elements;
    private final BBModelParts.Resolution resolution;

    public BlockbenchModel(BlockbenchLoader.BlockbenchSetting settings, BBModel model) {
        this.settings = settings;
        this.elements = model.elements;
        this.resolution = model.resolution;
    }

    protected void addQuads(IGeometryBakingContext owner, IModelBuilder<?> modelBuilder, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
        BBModelParts.Element rootNode = null;
        for (BBModelParts.Element element : this.elements) {
            if (!Objects.equals(element.name.toLowerCase(), "root_node") || !Objects.equals(element.type, "locator")) continue;
            rootNode = element;
        }
        for (BBModelParts.Element element : this.elements) {
            if (element.faces == null) continue;
            for (Direction direction : element.faces.keySet()) {
                BBModelParts.Face face = element.faces.get(direction);
                String textureString = this.settings.material;
                Material renderMaterial = UnbakedGeometryHelper.resolveDirtyMaterial((String)textureString, (IGeometryBakingContext)owner);
                TextureAtlasSprite texture = spriteGetter.apply(renderMaterial);
                modelBuilder.addUnculledFace(this.BAKERY.bakeQuad(element, this.settings, rootNode, face.uv, this.resolution, texture, direction, modelTransform));
            }
        }
    }
}

