/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.lib.turtle;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.common.util.DataStorageUtil;
import de.srendi.advancedperipherals.lib.peripherals.IBasePeripheral;
import de.srendi.advancedperipherals.lib.turtle.PeripheralTurtleUpgrade;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class ClockwiseAnimatedTurtleUpgrade<T extends IBasePeripheral<?>>
extends PeripheralTurtleUpgrade<T> {
    public static final String STORED_DATA_TAG = "storedData";

    protected ClockwiseAnimatedTurtleUpgrade(ResourceLocation id, ItemStack item) {
        super(id, item);
    }

    public void chargeConsumingCallback() {
    }

    public ItemStack getUpgradeItem(CompoundTag upgradeData) {
        if (upgradeData.m_128456_()) {
            return this.getCraftingItem();
        }
        ItemStack baseItem = this.getCraftingItem().m_41777_();
        baseItem.m_41700_(STORED_DATA_TAG, (Tag)upgradeData);
        return baseItem;
    }

    public CompoundTag getUpgradeData(ItemStack stack) {
        CompoundTag storedData = stack.m_41737_(STORED_DATA_TAG);
        if (storedData == null) {
            return new CompoundTag();
        }
        return storedData;
    }

    @Override
    public boolean isItemSuitable(ItemStack stack) {
        if (stack.m_41737_(STORED_DATA_TAG) == null) {
            return super.isItemSuitable(stack);
        }
        ItemStack tweakedStack = stack.m_41777_();
        tweakedStack.m_41784_().m_128473_(STORED_DATA_TAG);
        return super.isItemSuitable(tweakedStack);
    }

    public void update(@NotNull ITurtleAccess turtle, @NotNull TurtleSide side) {
        super.update(turtle, side);
        if (this.tick % 2 == 0 && DataStorageUtil.RotationCharge.consume(turtle, side)) {
            this.chargeConsumingCallback();
        }
    }
}

