/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import com.mojang.datafixers.util.Either;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.event.ClientEventHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.GlobalClock;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.WorldHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModTags;

public abstract class ItemSearchable
extends ItemGeneric {
    protected static final String TARGET_FOUND_NBT_BOOL = "target_found";
    protected static final String SEARCH_COOLDOWN_NBT_LONG = "search_cooldown";
    protected static final String TARGET_NBT_LOCATION = "target_location";

    protected ItemSearchable(String name, BooleanSupplier supplierEnabled) {
        super(name, ItemSearchable.getBuilder().m_41487_(1).m_41486_(), supplierEnabled);
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        this.addItemDesc(tooltip);
        if (Optional.ofNullable(ModTombstone.PROXY.getClientPlayer()).map(p -> !this.isInVillageRange((Player)p, stack)).orElse(true).booleanValue()) {
            this.addItemDistance(tooltip, this.getCurrentTarget(stack));
        }
        this.addItemUse(tooltip, this.isTargetFound(stack) ? "2" : "1", new Object[0]);
        super.addTooltipInfo(stack, level, tooltip);
    }

    public Component m_7626_(ItemStack stack) {
        return super.m_7626_(stack).m_6879_().m_6270_(StyleType.MESSAGE_SPECIAL);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (EntityHelper.isValidPlayer(context.m_43723_()) && this.isTargetFound(stack) && this.isInVillageRange(context.m_43723_(), stack) && context.m_8083_().equals((Object)this.getCurrentTarget(stack).getPos())) {
            if (!context.m_43723_().m_9236_().m_5776_()) {
                this.giveReward((ServerPlayer)context.m_43723_(), context.m_8083_());
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (stack.m_150930_((Item)this) && level != null && EntityHelper.isValidPlayer(entity)) {
            if (level.m_5776_()) {
                if (isSelected && entity.equals((Object)ModTombstone.PROXY.getClientPlayer())) {
                    ClientEventHandler.toDisplay = this.getMessageToDisplay((Player)entity, stack);
                }
            } else {
                ServerPlayer player = (ServerPlayer)entity;
                if (this.getCurrentTarget(stack).isOrigin()) {
                    if (NBTStackHelper.hasTimer(GlobalClock.INSTANCE.getTime(player.m_9236_()), stack, SEARCH_COOLDOWN_NBT_LONG, 1200)) {
                        return;
                    }
                    assert (player.m_20194_() != null);
                    int d1 = (Helper.RANDOM.nextBoolean() ? -400 : 400) + Helper.RANDOM.nextInt(401) - 200;
                    int d2 = Helper.RANDOM.nextInt(1001) - 500;
                    boolean inverse = Helper.RANDOM.nextBoolean();
                    Location loc = (Location)WorldHelper.findNearestStructure(player.m_20194_().m_129783_(), player.m_20183_().m_7918_(inverse ? d2 : d1, 0, inverse ? d1 : d2), ModTags.Structures.vanilla_villages, false).getLeft();
                    if (loc.isOrigin()) {
                        NBTStackHelper.setLong(stack, SEARCH_COOLDOWN_NBT_LONG, GlobalClock.INSTANCE.getTime(player.m_9236_()) + 1200L);
                    } else {
                        NBTStackHelper.setLocation(stack, TARGET_NBT_LOCATION, loc);
                    }
                } else if (!this.isTargetFound(stack) && this.isInVillageRange((Player)player, stack) && Helper.RANDOM.nextInt(10) == 0) {
                    BlockPos villageCenter = this.getCurrentTarget(stack).getPos();
                    Stream pois = player.m_284548_().m_8904_().m_27166_(poiType -> poiType.m_203565_(this.getTargetType()), villageCenter, 64, PoiManager.Occupancy.ANY);
                    Either<TagKey<Block>, Block> matcher = this.getTargetMatcher();
                    Optional<BlockPos> targetPos = pois.map(PoiRecord::m_27257_).filter(pos -> {
                        BlockState state = player.m_9236_().m_8055_(pos);
                        return (Boolean)matcher.map(arg_0 -> ((BlockState)state).m_204336_(arg_0), b -> state.m_60734_() == b);
                    }).min(Comparator.comparingDouble(pos -> pos.m_123331_((Vec3i)villageCenter)));
                    if (targetPos.isPresent()) {
                        NBTStackHelper.setBoolean(stack, TARGET_FOUND_NBT_BOOL, true);
                        NBTStackHelper.setLocation(stack, TARGET_NBT_LOCATION, new Location(targetPos.get(), player.m_9236_()));
                    } else {
                        @Nullable Block forcedBlock = this.getTargetForcedBlock();
                        if (forcedBlock != null) {
                            BlockPos placeAt = player.m_9236_().m_5452_(Heightmap.Types.WORLD_SURFACE, villageCenter);
                            player.m_9236_().m_7731_(placeAt, this.getTargetForcedBlock().m_49966_(), 3);
                            NBTStackHelper.setBoolean(stack, TARGET_FOUND_NBT_BOOL, true);
                            NBTStackHelper.setLocation(stack, TARGET_NBT_LOCATION, new Location(placeAt, player.m_9236_()));
                        } else {
                            NBTStackHelper.removeLocation(stack, TARGET_NBT_LOCATION);
                        }
                    }
                }
            }
        }
    }

    public boolean isTargetFound(ItemStack stack) {
        return NBTStackHelper.getBoolean(stack, TARGET_FOUND_NBT_BOOL);
    }

    public Location getCurrentTarget(ItemStack stack) {
        return NBTStackHelper.getLocation(stack, TARGET_NBT_LOCATION);
    }

    public boolean isInVillageRange(Player player, ItemStack stack) {
        double dz;
        if (!player.m_9236_().m_46472_().equals((Object)Level.f_46428_)) {
            return false;
        }
        Location targetLocation = this.getCurrentTarget(stack);
        if (targetLocation.isOrigin()) {
            return false;
        }
        double dx = (double)targetLocation.x + 0.5 - player.m_20185_();
        return dx * dx + (dz = (double)targetLocation.z + 0.5 - player.m_20189_()) * dz < 900.0;
    }

    protected abstract void giveReward(ServerPlayer var1, BlockPos var2);

    protected abstract ResourceKey<PoiType> getTargetType();

    protected abstract Either<TagKey<Block>, Block> getTargetMatcher();

    @Nullable
    protected abstract Block getTargetForcedBlock();

    protected abstract String getMessageToDisplay(Player var1, ItemStack var2);
}

