/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.compatibility.CompatibilityCurio;
import ovh.corail.tombstone.compatibility.CompatibilityDragonSurvival;
import ovh.corail.tombstone.compatibility.CompatibilityEnigmatic;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.registry.ModTags;

public final class InventoryHelper {
    private static final IItemHandler EMPTY_ITEM_HANDLER = new ItemStackHandler(NonNullList.m_122779_());

    public static void autoequip(ServerPlayer player, ItemStackHandler itemHandler, Item lastOffhandItem) {
        Predicate<ItemStack> filter = stack -> lastOffhandItem != Items.f_41852_ ? stack.m_150930_(lastOffhandItem) || InventoryHelper.getStackFilter(player).test((ItemStack)stack) : InventoryHelper.getStackFilter(player).test((ItemStack)stack);
        List<Integer> itemIds = IntStream.range(0, itemHandler.getSlots()).filter(i -> filter.test(itemHandler.getStackInSlot(i))).mapToObj(Integer.class::cast).collect(Collectors.toList());
        if (SupportMods.CURIOS.isLoaded() && ((Boolean)ConfigTombstone.compatibility.curioAutoEquip.get()).booleanValue()) {
            CompatibilityCurio.instance.autoEquip(player, itemHandler, itemIds);
        }
        ListIterator idIterator = itemIds.listIterator(itemIds.size());
        while (idIterator.hasPrevious()) {
            int slotId = (Integer)idIterator.previous();
            if (!InventoryHelper.autoequip(itemHandler.getStackInSlot(slotId), player, lastOffhandItem)) continue;
            itemHandler.setStackInSlot(slotId, ItemStack.f_41583_);
        }
    }

    private static Predicate<ItemStack> getStackFilter(ServerPlayer player) {
        Predicate<ItemStack> predic = stack -> !stack.m_41619_() && !EnchantmentHelper.m_44920_((ItemStack)stack);
        if (SupportMods.CURIOS.isLoaded() && !PlayerPreference.get(player).equipCurioSlotMagicBook()) {
            predic = predic.and(stack -> !stack.m_204117_(ModTags.Items.magic_books));
        }
        if (SupportMods.ENIGMATIC_LEGACY.isLoaded()) {
            predic = predic.and(stack -> !CompatibilityEnigmatic.instance.isDenied((ItemStack)stack));
        }
        if (SupportMods.POWERSUITS.isLoaded()) {
            predic = predic.and(stack -> !RegistryHelper.isValid(stack.m_41720_(), rl -> "powersuits".equals(rl.m_135827_())));
        }
        return predic;
    }

    private static boolean autoequip(ItemStack stack, ServerPlayer player, Item lastOffhandItem) {
        if (SupportMods.DRAGON_SURVIVAL.isLoaded() && CompatibilityDragonSurvival.instance.autoEquip(stack, (Player)player)) {
            return true;
        }
        @Nullable EquipmentSlot slot = InventoryHelper.getEquipmentSlot(stack);
        if (lastOffhandItem != Items.f_41852_ ? stack.m_150930_(lastOffhandItem) : slot == EquipmentSlot.OFFHAND) {
            ItemStack offhandStack = player.m_21206_();
            if (offhandStack.m_41619_()) {
                player.m_150109_().f_35976_.set(0, (Object)stack.m_41777_());
                return true;
            }
            if (!PlayerPreference.get(player).equipShieldInPriority() && !offhandStack.m_150930_(lastOffhandItem)) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)offhandStack.m_41777_());
                player.m_150109_().f_35976_.set(0, (Object)stack.m_41777_());
                return true;
            }
            return false;
        }
        if (slot == null || slot == EquipmentSlot.MAINHAND) {
            return false;
        }
        ItemStack stackInSlot = player.m_6844_(slot);
        if (slot == EquipmentSlot.OFFHAND) {
            if (PlayerPreference.get(player).equipShieldInPriority() && InventoryHelper.isShield(stack) && !InventoryHelper.isShield(stackInSlot)) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stackInSlot.m_41777_());
                player.m_150109_().f_35976_.set(0, (Object)stack.m_41777_());
                return true;
            }
            return false;
        }
        int slotId = slot.m_20749_();
        if (stackInSlot.m_41619_()) {
            player.m_150109_().f_35975_.set(slotId, (Object)stack.m_41777_());
            return true;
        }
        if (slot == EquipmentSlot.CHEST && PlayerPreference.get(player).equipElytraInPriority() && InventoryHelper.isElytra(stack) && !InventoryHelper.isElytra(stackInSlot)) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stackInSlot.m_41777_());
            player.m_150109_().f_35975_.set(slotId, (Object)stack.m_41777_());
            return true;
        }
        return false;
    }

    @Nullable
    private static EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return Optional.ofNullable(stack.m_41720_().getEquipmentSlot(stack)).orElse(Optional.ofNullable(Equipable.m_269088_((ItemStack)stack)).map(Equipable::m_40402_).orElse(null));
    }

    private static boolean isElytra(ItemStack stack) {
        return stack.m_41720_() instanceof ElytraItem;
    }

    private static boolean isShield(ItemStack stack) {
        return stack.m_41720_().canPerformAction(stack, ToolActions.SHIELD_BLOCK);
    }

    public static boolean isToolOrMelee(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41741_() == 1 && (stack.m_41720_() instanceof TieredItem || stack.m_41720_() instanceof FishingRodItem || stack.m_41720_() instanceof ShearsItem || stack.m_41720_() instanceof TridentItem);
    }

    public static IItemHandler getItemHandler(Entity entity) {
        return (IItemHandler)entity.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse((Object)EMPTY_ITEM_HANDLER);
    }

    public static ItemStack findFirstInInventory(@Nullable Player player, Item item) {
        return InventoryHelper.findFirstInInventory(player, (ItemStack stack) -> stack.m_150930_(item));
    }

    public static ItemStack findFirstInInventory(@Nullable Player player, Predicate<ItemStack> predic) {
        if (player != null) {
            IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)player);
            return IntStream.range(0, itemHandler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)itemHandler).getStackInSlot(arg_0)).filter(predic).findFirst().orElse(ItemStack.f_41583_);
        }
        return ItemStack.f_41583_;
    }

    public static boolean removeFirstInInventory(Player player, Predicate<ItemStack> predic) {
        IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)player);
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (!predic.test(stack)) continue;
            itemHandler.extractItem(i, 1, false);
            return true;
        }
        return false;
    }

    public static boolean hasEnoughSlots(IItemHandler itemHandler, int count) {
        int found = 0;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (!itemHandler.getStackInSlot(i).m_41619_() || ++found < count) continue;
            return true;
        }
        return false;
    }
}

