/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import java.util.stream.Collectors;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModTriggers;

public final class EnchantmentMagicSiphon
extends TombstoneEnchantment {
    public EnchantmentMagicSiphon() {
        super("magic_siphon", Enchantment.Rarity.UNCOMMON, ModTombstone.TYPE_TOMBSTONE_ALL_WEAPONS, EquipmentSlot.MAINHAND);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)SharedConfigTombstone.enchantments.enableEnchantmentMagicSiphon.get();
    }

    protected boolean m_5975_(Enchantment ench) {
        return ench != ModEnchantments.plague_bringer && super.m_5975_(ench);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return (Boolean)SharedConfigTombstone.enchantments.magicSiphonEnchantingTable.get() != false && super.canApplyAtEnchantingTable(stack);
    }

    public void m_7677_(LivingEntity attacker, Entity entity, int amplifier) {
        MobEffectInstance targetEffectInstance;
        LivingEntity target;
        if (entity instanceof LivingEntity && !(target = (LivingEntity)entity).m_9236_().m_5776_() && target.m_6084_() && attacker != null && attacker.m_6084_() && (targetEffectInstance = (MobEffectInstance)Helper.getRandomInList(target.m_21220_().stream().filter(EffectHelper::isAllowedEffect).collect(Collectors.toList())).orElse(null)) != null) {
            int oldDuration;
            int stolenDuration = TimeHelper.tickFromSecond(30 * amplifier);
            if (!targetEffectInstance.m_267577_() && stolenDuration > targetEffectInstance.m_19557_()) {
                stolenDuration = targetEffectInstance.m_19557_();
            }
            if ((oldDuration = EffectHelper.getDuration(attacker, targetEffectInstance.m_19544_(), targetEffectInstance.m_19564_())) >= 0) {
                attacker.m_7292_(new MobEffectInstance(targetEffectInstance.m_19544_(), Mth.m_14045_((int)(stolenDuration + oldDuration), (int)-1, (int)Integer.MAX_VALUE), targetEffectInstance.m_19564_()));
            }
            if (!targetEffectInstance.m_267577_()) {
                EffectHelper.clearEffect(target, targetEffectInstance.m_19544_());
                if (stolenDuration < targetEffectInstance.m_19557_()) {
                    targetEffectInstance.f_19503_ -= stolenDuration;
                    target.m_7292_(targetEffectInstance);
                }
                if (target.m_21223_() > target.m_21233_()) {
                    target.m_21153_(target.m_21233_());
                }
            }
            if (EntityHelper.isValidServerPlayer((Entity)attacker)) {
                ModTriggers.STEAL_EFFECT.trigger((ServerPlayer)attacker);
            }
        }
    }
}

