/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.sequenced;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.Create;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipeSerializer;
import com.simibubi.create.content.processing.sequenced.SequencedRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.createmod.catnip.data.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class SequencedAssemblyRecipe
implements Recipe<RecipeWrapper> {
    protected ResourceLocation id;
    protected SequencedAssemblyRecipeSerializer serializer;
    protected Ingredient ingredient;
    protected List<SequencedRecipe<?>> sequence;
    protected int loops;
    protected ProcessingOutput transitionalItem;
    public final List<ProcessingOutput> resultPool;

    public SequencedAssemblyRecipe(ResourceLocation recipeId, SequencedAssemblyRecipeSerializer serializer) {
        this.id = recipeId;
        this.serializer = serializer;
        this.sequence = new ArrayList();
        this.resultPool = new ArrayList<ProcessingOutput>();
        this.loops = 5;
    }

    public static <C extends Container, R extends ProcessingRecipe<C>> Optional<R> getRecipe(Level world, C inv, RecipeType<R> type, Class<R> recipeClass) {
        return SequencedAssemblyRecipe.getRecipe(world, inv, type, recipeClass, r -> r.m_5818_(inv, world));
    }

    public static <C extends Container, R extends ProcessingRecipe<C>> Optional<R> getRecipe(Level world, C inv, RecipeType<R> type, Class<R> recipeClass, Predicate<? super R> recipeFilter) {
        return SequencedAssemblyRecipe.getRecipes(world, inv.m_8020_(0), type, recipeClass).filter(recipeFilter).findFirst();
    }

    public static <R extends ProcessingRecipe<?>> Optional<R> getRecipe(Level world, ItemStack item, RecipeType<R> type, Class<R> recipeClass) {
        List all = world.m_7465_().m_44013_(AllRecipeTypes.SEQUENCED_ASSEMBLY.getType());
        for (SequencedAssemblyRecipe sequencedAssemblyRecipe : all) {
            SequencedRecipe<?> nextRecipe;
            ProcessingRecipe<?> recipe;
            if (!sequencedAssemblyRecipe.appliesTo(item) || (recipe = (nextRecipe = sequencedAssemblyRecipe.getNextRecipe(item)).getRecipe()).m_6671_() != type || !recipeClass.isInstance(recipe)) continue;
            recipe.enforceNextResult(() -> sequencedAssemblyRecipe.advance(item));
            return Optional.of((ProcessingRecipe)recipeClass.cast(recipe));
        }
        return Optional.empty();
    }

    public static <R extends ProcessingRecipe<?>> Stream<R> getRecipes(Level world, ItemStack item, RecipeType<R> type, Class<R> recipeClass) {
        List all = world.m_7465_().m_44013_(AllRecipeTypes.SEQUENCED_ASSEMBLY.getType());
        return all.stream().filter(it -> it.appliesTo(item)).map(it -> Pair.of((Object)it, it.getNextRecipe(item).getRecipe())).filter(it -> ((ProcessingRecipe)it.getSecond()).m_6671_() == type && recipeClass.isInstance(it.getSecond())).map(it -> {
            ((ProcessingRecipe)it.getSecond()).enforceNextResult(() -> ((SequencedAssemblyRecipe)it.getFirst()).advance(item));
            return (ProcessingRecipe)it.getSecond();
        }).map(recipeClass::cast);
    }

    private ItemStack advance(ItemStack input) {
        int step = this.getStep(input);
        if ((step + 1) / this.sequence.size() >= this.loops) {
            return this.rollResult();
        }
        ItemStack advancedItem = ItemHandlerHelper.copyStackWithSize((ItemStack)this.getTransitionalItem(), (int)1);
        CompoundTag itemTag = advancedItem.m_41784_();
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", this.id.toString());
        tag.m_128405_("Step", step + 1);
        tag.m_128350_("Progress", ((float)step + 1.0f) / (float)(this.sequence.size() * this.loops));
        itemTag.m_128365_("SequencedAssembly", (Tag)tag);
        advancedItem.m_41751_(itemTag);
        return advancedItem;
    }

    public int getLoops() {
        return this.loops;
    }

    public void addAdditionalIngredientsAndMachines(List<Ingredient> list) {
        this.sequence.forEach(sr -> sr.getAsAssemblyRecipe().addAssemblyIngredients(list));
        HashSet machines = new HashSet();
        this.sequence.forEach(sr -> sr.getAsAssemblyRecipe().addRequiredMachines(machines));
        machines.stream().map(xva$0 -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{xva$0})).forEach(list::add);
    }

    public void addAdditionalFluidIngredients(List<FluidIngredient> list) {
        this.sequence.forEach(sr -> sr.getAsAssemblyRecipe().addAssemblyFluidIngredients(list));
    }

    private ItemStack rollResult() {
        float totalWeight = 0.0f;
        for (ProcessingOutput entry : this.resultPool) {
            totalWeight += entry.getChance();
        }
        float number = Create.RANDOM.nextFloat() * totalWeight;
        for (ProcessingOutput entry : this.resultPool) {
            if (!((number -= entry.getChance()) < 0.0f)) continue;
            return entry.getStack().m_41777_();
        }
        return ItemStack.f_41583_;
    }

    private boolean appliesTo(ItemStack input) {
        if (input.m_41782_() && input.m_41783_().m_128441_("SequencedAssembly")) {
            return this.getTransitionalItem().m_41720_() == input.m_41720_() && input.m_41783_().m_128469_("SequencedAssembly").m_128461_("id").equals(this.id.toString());
        }
        return this.ingredient.test(input);
    }

    private SequencedRecipe<?> getNextRecipe(ItemStack input) {
        return this.sequence.get(this.getStep(input) % this.sequence.size());
    }

    private int getStep(ItemStack input) {
        if (!input.m_41782_()) {
            return 0;
        }
        CompoundTag tag = input.m_41783_();
        if (!tag.m_128441_("SequencedAssembly")) {
            return 0;
        }
        int step = tag.m_128469_("SequencedAssembly").m_128451_("Step");
        return step;
    }

    public boolean matches(RecipeWrapper inv, Level p_77569_2_) {
        return false;
    }

    public ItemStack assemble(RecipeWrapper inv, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int p_194133_1_, int p_194133_2_) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.resultPool.get(0).getStack();
    }

    public float getOutputChance() {
        float totalWeight = 0.0f;
        for (ProcessingOutput entry : this.resultPool) {
            totalWeight += entry.getChance();
        }
        return this.resultPool.get(0).getChance() / totalWeight;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return this.serializer;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeType<?> m_6671_() {
        return AllRecipeTypes.SEQUENCED_ASSEMBLY.getType();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addToTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_("SequencedAssembly")) {
            return;
        }
        CompoundTag compound = stack.m_41783_().m_128469_("SequencedAssembly");
        ResourceLocation resourceLocation = new ResourceLocation(compound.m_128461_("id"));
        Optional optionalRecipe = Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(resourceLocation);
        if (!optionalRecipe.isPresent()) {
            return;
        }
        Recipe recipe = (Recipe)optionalRecipe.get();
        if (!(recipe instanceof SequencedAssemblyRecipe)) {
            return;
        }
        SequencedAssemblyRecipe sequencedAssemblyRecipe = (SequencedAssemblyRecipe)recipe;
        int length = sequencedAssemblyRecipe.sequence.size();
        int step = sequencedAssemblyRecipe.getStep(stack);
        int total = length * sequencedAssemblyRecipe.loops;
        List tooltip = event.getToolTip();
        tooltip.add(CommonComponents.f_237098_);
        tooltip.add(CreateLang.translateDirect("recipe.sequenced_assembly", new Object[0]).m_130940_(ChatFormatting.GRAY));
        tooltip.add(CreateLang.translateDirect("recipe.assembly.progress", step, total).m_130940_(ChatFormatting.DARK_GRAY));
        int remaining = total - step;
        for (int i = 0; i < length && i < remaining; ++i) {
            SequencedRecipe<?> sequencedRecipe = sequencedAssemblyRecipe.sequence.get((i + step) % length);
            Component textComponent = sequencedRecipe.getAsAssemblyRecipe().getDescriptionForAssembly();
            if (i == 0) {
                tooltip.add(CreateLang.translateDirect("recipe.assembly.next", textComponent).m_130940_(ChatFormatting.AQUA));
                continue;
            }
            tooltip.add(Component.m_237113_((String)"-> ").m_7220_(textComponent).m_130940_(ChatFormatting.DARK_AQUA));
        }
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public List<SequencedRecipe<?>> getSequence() {
        return this.sequence;
    }

    public ItemStack getTransitionalItem() {
        return this.transitionalItem.getStack();
    }
}

