/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.registry;

import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.config.SpawnConfig;
import dev.xylonity.companions.registry.CompanionsEntities;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public class CompanionsSpawns {
    private static final SpawnConfig GOLDEN_ALLAY_SPAWN_CONFIG = SpawnConfig.parse(CompanionsConfig.GOLDEN_ALLAY_SPAWN);
    private static final SpawnConfig CORNELIUS_SPAWN_CONFIG = SpawnConfig.parse(CompanionsConfig.CORNELIUS_SPAWN);
    private static final SpawnConfig WILD_ANTLION_SPAWN_CONFIG = SpawnConfig.parse(CompanionsConfig.WILD_ANTLION_SPAWN);

    public static void addBiomeSpawns(Holder<Biome> biomeHolder, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        int max;
        int min;
        int weight;
        if (GOLDEN_ALLAY_SPAWN_CONFIG.matches(biomeHolder)) {
            weight = CompanionsSpawns.GOLDEN_ALLAY_SPAWN_CONFIG.weight;
            min = CompanionsSpawns.GOLDEN_ALLAY_SPAWN_CONFIG.minCount;
            max = CompanionsSpawns.GOLDEN_ALLAY_SPAWN_CONFIG.maxCount;
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)CompanionsEntities.GOLDEN_ALLAY.get(), weight, min, max));
        }
        if (CORNELIUS_SPAWN_CONFIG.matches(biomeHolder)) {
            weight = CompanionsSpawns.CORNELIUS_SPAWN_CONFIG.weight;
            min = CompanionsSpawns.CORNELIUS_SPAWN_CONFIG.minCount;
            max = CompanionsSpawns.CORNELIUS_SPAWN_CONFIG.maxCount;
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)CompanionsEntities.CORNELIUS.get(), weight, min, max));
        }
        if (WILD_ANTLION_SPAWN_CONFIG.matches(biomeHolder)) {
            weight = CompanionsSpawns.WILD_ANTLION_SPAWN_CONFIG.weight;
            min = CompanionsSpawns.WILD_ANTLION_SPAWN_CONFIG.minCount;
            max = CompanionsSpawns.WILD_ANTLION_SPAWN_CONFIG.maxCount;
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)CompanionsEntities.WILD_ANTLION.get(), weight, min, max));
        }
    }
}

