/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.registry;

import dev.xylonity.companions.common.blockentity.SoulFurnaceBlockEntity;
import dev.xylonity.companions.common.container.CorneliusContainerMenu;
import dev.xylonity.companions.common.container.PuppetContainerMenu;
import dev.xylonity.companions.common.container.SoulFurnaceContainerMenu;
import dev.xylonity.companions.common.container.SoulMageContainerMenu;
import dev.xylonity.companions.common.entity.companion.CorneliusEntity;
import dev.xylonity.companions.common.entity.companion.PuppetEntity;
import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class CompanionsMenuTypes {
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"companions");
    public static final RegistryObject<MenuType<SoulFurnaceContainerMenu>> SOUL_FURNACE = CompanionsMenuTypes.registerMenu("soul_furnace_container_menu", (id, inv, buf) -> {
        BlockPos pos = buf.m_130135_();
        BlockEntity be = inv.f_35978_.m_9236_().m_7702_(pos);
        if (be instanceof SoulFurnaceBlockEntity) {
            SoulFurnaceBlockEntity furnace = (SoulFurnaceBlockEntity)be;
            return new SoulFurnaceContainerMenu(id, inv, furnace, (ContainerData)new SimpleContainerData(3));
        }
        throw new IllegalStateException(String.valueOf(pos));
    });
    public static final RegistryObject<MenuType<SoulMageContainerMenu>> SOUL_MAGE_CONTAINER = CompanionsMenuTypes.registerMenu("soul_mage_container_menu", (id, inv, buf) -> {
        int entityId = buf.readInt();
        Entity entity = inv.f_35978_.m_9236_().m_6815_(entityId);
        if (entity instanceof SoulMageEntity) {
            SoulMageEntity soulMage = (SoulMageEntity)entity;
            return new SoulMageContainerMenu(id, inv, soulMage);
        }
        throw new IllegalStateException("" + entityId);
    });
    public static final RegistryObject<MenuType<PuppetContainerMenu>> PUPPET_CONTAINER = CompanionsMenuTypes.registerMenu("puppet_container_menu", (id, inv, buf) -> {
        int entityId = buf.readInt();
        Entity entity = inv.f_35978_.m_9236_().m_6815_(entityId);
        if (entity instanceof PuppetEntity) {
            PuppetEntity puppet = (PuppetEntity)entity;
            return new PuppetContainerMenu(id, inv, puppet);
        }
        throw new IllegalStateException("" + entityId);
    });
    public static final RegistryObject<MenuType<CorneliusContainerMenu>> CORNELIUS_CONTAINER = CompanionsMenuTypes.registerMenu("cornelius_container_menu", (id, inv, buf) -> {
        int entityId = buf.readInt();
        Entity entity = inv.f_35978_.m_9236_().m_6815_(entityId);
        if (entity instanceof CorneliusEntity) {
            CorneliusEntity puppet = (CorneliusEntity)entity;
            return new CorneliusContainerMenu(id, inv, puppet);
        }
        throw new IllegalStateException("" + entityId);
    });

    public static <T extends AbstractContainerMenu> RegistryObject<MenuType<T>> registerMenu(String name, MenuFactory<T> factory) {
        return MENU_TYPES.register(name, () -> IForgeMenuType.create(factory::create));
    }

    @FunctionalInterface
    public static interface MenuFactory<T extends AbstractContainerMenu> {
        public T create(int var1, Inventory var2, FriendlyByteBuf var3);
    }
}

