/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.tesla.behaviour.lamp;

import dev.xylonity.companions.common.block.PlasmaLampBlock;
import dev.xylonity.companions.common.blockentity.AbstractTeslaBlockEntity;
import dev.xylonity.companions.common.tesla.TeslaConnectionManager;
import dev.xylonity.companions.common.util.interfaces.ITeslaNodeBehaviour;
import dev.xylonity.companions.registry.CompanionsParticles;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LampPulseBehaviour
implements ITeslaNodeBehaviour {
    @Override
    public void process(AbstractTeslaBlockEntity lamp, Level level, BlockPos blockPos, BlockState blockState) {
        ArrayList<TeslaConnectionManager.ConnectionNode> oldConnections = new ArrayList<TeslaConnectionManager.ConnectionNode>(lamp.connectionManager.getIncoming(lamp.asConnectionNode()));
        if (lamp.cycleCounter >= 0) {
            if (lamp.isActive() && lamp.cycleCounter % 4 == 0) {
                for (int i = 0; i < 360; i += 120) {
                    Random random = new Random();
                    if (!(random.nextFloat() < 0.6f)) continue;
                    double radius = 0.2;
                    double angleRadians = Math.toRadians(i);
                    double particleX = (double)lamp.m_58899_().m_123341_() + 0.5 + radius * Math.cos(angleRadians);
                    double particleZ = (double)lamp.m_58899_().m_123343_() + 0.5 + radius * Math.sin(angleRadians);
                    double particleY = (double)lamp.m_58899_().m_123342_() + 0.5 + 1.0 * Math.random();
                    level.m_7106_((ParticleOptions)CompanionsParticles.DINAMO_SPARK.get(), particleX, particleY, particleZ, 0.0, 0.35, 0.0);
                }
            }
            if (lamp.cycleCounter == 0) {
                lamp.setActive(true);
                level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)PlasmaLampBlock.LIT, (Comparable)Boolean.valueOf(true)));
                this.linkLamp(lamp, level, blockPos, oldConnections);
            }
            if (lamp.cycleCounter == 14) {
                lamp.cycleCounter = -1;
                level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)PlasmaLampBlock.LIT, (Comparable)Boolean.valueOf(false)));
                this.linkLamp(lamp, level, blockPos, oldConnections);
                lamp.setActive(false);
            } else {
                ++lamp.cycleCounter;
                ++lamp.tickCount;
            }
        }
    }

    private void linkLamp(AbstractTeslaBlockEntity lamp, Level level, BlockPos blockPos, List<TeslaConnectionManager.ConnectionNode> oldConnections) {
        BlockEntity newBe = level.m_7702_(blockPos);
        if (newBe instanceof AbstractTeslaBlockEntity) {
            AbstractTeslaBlockEntity newLamp = (AbstractTeslaBlockEntity)newBe;
            for (TeslaConnectionManager.ConnectionNode node : oldConnections) {
                newLamp.connectionManager.addConnection(node, newLamp.asConnectionNode(), false);
            }
            TeslaConnectionManager.getInstance().registerBlockEntity(newLamp);
        }
    }
}

