/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.particle;

import dev.xylonity.knightlib.client.particle.AbstractRibbonTrailParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RedElectricArcParticle
extends AbstractRibbonTrailParticle {
    private static final ResourceLocation TEXTURE = new ResourceLocation("companions", "textures/particle/trail4.png");
    private static final int TRAIL_SEGMS = 12;
    private final Vec3 start;
    private final Vec3 end;
    private final double arcY;
    private final Vec3[] noiseOffsets;
    private static final float RED_ = 0.92156863f;
    private static final float GREEN_ = 0.3529412f;
    private static final float BLUE_ = 0.21568628f;
    private final boolean whiteStart;
    private final long seed;
    private final double amp;

    public RedElectricArcParticle(ClientLevel level, Vec3 start, Vec3 end, double arcHeight, double amp, boolean whiteStart, int lifetime) {
        super(level, start.f_82479_, start.f_82480_, start.f_82481_, 0.0, 0.0, 0.0, 1.0f, 1.0f, 1.0f);
        this.start = start;
        this.end = end;
        this.arcY = arcHeight;
        this.whiteStart = whiteStart;
        this.seed = level.f_46441_.m_188505_();
        this.amp = amp;
        this.noiseOffsets = new Vec3[12];
        for (int i = 0; i < 12; ++i) {
            long h = level.f_46441_.m_188505_() ^ (long)i * 2654435769L;
            h ^= h >>> 33;
            h *= -49064778989728563L;
            h ^= h >>> 33;
            h *= -4265267296055464877L;
            h ^= h >>> 33;
            double ox = ((double)(h >> 42 & 0x3FFL) / 1023.0 - 0.5) * amp;
            double oy = ((double)(h >> 21 & 0x3FFL) / 1023.0 - 0.5) * amp;
            double oz = ((double)(h & 0x3FFL) / 1023.0 - 0.5) * amp;
            this.noiseOffsets[i] = new Vec3(ox, oy, oz);
        }
        this.f_107226_ = 0.0f;
        this.f_107225_ = lifetime;
        this.ribbonAlpha = 1.0f;
        this.m_107259_(new AABB(start, end).m_82400_(amp).m_82363_(0.0, this.arcY, 0.0));
    }

    protected ResourceLocation getRibbonSprite() {
        return TEXTURE;
    }

    protected int totalSegments() {
        return Math.min(12, (this.f_107224_ + 1) * 3);
    }

    public void m_5989_() {
        super.m_5989_();
        int rem = this.f_107225_;
        int dWhite = Math.min(1, rem);
        int dFadeIn = Math.min(this.whiteStart ? (int)((double)this.f_107225_ * 0.4) : 3, rem -= dWhite);
        int dDarken = this.whiteStart ? Math.min(5, rem -= dFadeIn) : this.f_107225_ - 5;
        int fadein = dWhite + dFadeIn;
        int toDarken = fadein + dDarken;
        if (this.whiteStart) {
            if (this.f_107224_ < dWhite) {
                this.r = 1.0f;
                this.g = 1.0f;
                this.b = 1.0f;
            } else if (this.f_107224_ < fadein) {
                float p = (float)(this.f_107224_ - dWhite) / (float)dFadeIn;
                this.r = 1.0f - p * 0.07843137f;
                this.g = 1.0f - p * 0.64705884f;
                this.b = 1.0f - p * 0.78431374f;
            } else if (this.f_107224_ < toDarken) {
                factor = 1.0f - (float)(this.f_107224_ - fadein) / (float)dDarken * 0.4f;
                this.r = 0.92156863f * factor;
                this.g = 0.3529412f * factor;
                this.b = 0.21568628f * factor;
            } else {
                factor = 0.3f;
                this.r = 0.92156863f * factor;
                this.g = 0.3529412f * factor;
                this.b = 0.21568628f * factor;
            }
        } else if (this.f_107224_ < toDarken) {
            factor = 1.0f - (float)this.f_107224_ / (float)toDarken * 0.4f;
            this.r = 0.92156863f * factor;
            this.g = 0.3529412f * factor;
            this.b = 0.21568628f * factor;
        } else {
            factor = 0.3f;
            this.r = 0.92156863f * factor;
            this.g = 0.3529412f * factor;
            this.b = 0.21568628f * factor;
        }
        int fade = Math.min(6, this.f_107225_);
        this.ribbonAlpha = this.f_107224_ >= this.f_107225_ - fade ? Math.max(0.0f, 1.0f - (float)(this.f_107224_ - (this.f_107225_ - fade)) / (float)fade) : 1.0f;
    }

    protected int m_6355_(float $$0) {
        return 0xF000F0;
    }

    protected Vec3 sampleTrailPoint(int idx, float tick) {
        float t = (float)idx / 10.0f;
        Vec3 base = this.start.m_165921_(this.end, (double)t).m_82520_(0.0, Math.sin(Math.PI * (double)t) * this.arcY, 0.0);
        long h = this.seed ^ (long)this.f_107224_ << 1 ^ (long)idx * 2654435769L;
        h ^= h >>> 33;
        h *= -49064778989728563L;
        h ^= h >>> 33;
        h *= -4265267296055464877L;
        h ^= h >>> 33;
        double ox = ((double)(h >> 42 & 0x3FFL) / 1023.0 - 0.5) * this.amp;
        double oy = ((double)(h >> 21 & 0x3FFL) / 1023.0 - 0.5) * this.amp;
        double oz = ((double)(h & 0x3FFL) / 1023.0 - 0.5) * this.amp;
        return base.m_82520_(ox, oy, oz);
    }

    protected float getRibbonHeight() {
        return 0.28f;
    }
}

