/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.particle;

import dev.xylonity.knightlib.client.particle.AbstractRibbonTrailParticle;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class BaseRibbonTrailParticle
extends AbstractRibbonTrailParticle {
    private static final ResourceLocation TEXTURE = new ResourceLocation("companions", "textures/particle/trail.png");
    protected final float radius;
    protected final float height;
    protected final int targetId;
    protected final float startYaw;
    protected final float yawSpeed;
    protected float ribbonHeight;

    public BaseRibbonTrailParticle(ClientLevel level, double x, double y, double z, float r, float g, float b, float radius, float height, int targetId) {
        super(level, x, y, z, 0.0, 0.0, 0.0, r, g, b);
        this.radius = radius;
        this.height = height;
        this.targetId = targetId;
        this.f_107226_ = 0.0f;
        this.f_107225_ = 60;
        this.startYaw = level.f_46441_.m_188501_() * 360.0f;
        this.yawSpeed = (5.0f + level.f_46441_.m_188501_() * 5.0f) * (level.f_46441_.m_188499_() ? 1.0f : -1.0f);
        this.ribbonHeight = 0.35f;
        Vec3 p = this.orbitPos();
        this.m_107264_(p.f_82479_, p.f_82480_, p.f_82481_);
    }

    public BaseRibbonTrailParticle(ClientLevel level, double x, double y, double z, float r, float g, float b, float radius, float height, int targetId, float trailHeight) {
        this(level, x, y, z, r, g, b, radius, height, targetId);
        this.ribbonHeight = trailHeight;
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.getTarget() == null && this.targetId != -1) {
            this.m_107274_();
            return;
        }
        this.ribbonAlpha = 1.0f - (float)this.f_107224_ / (float)this.f_107225_;
        this.m_107264_(this.orbitPos().f_82479_, this.orbitPos().f_82480_, this.orbitPos().f_82481_);
    }

    private Vec3 orbitPos() {
        double alpha = Math.toRadians(this.startYaw + this.yawSpeed * (float)this.f_107224_);
        Vec3 off = new Vec3(Math.cos(alpha) * (double)this.radius, (double)this.height * Math.sin((float)this.f_107224_ * 0.1f), Math.sin(alpha) * (double)this.radius);
        return this.targetPos().m_82549_(off);
    }

    protected Vec3 targetPos() {
        return this.getTarget() != null ? this.getTarget().m_20182_().m_82520_(0.0, (double)this.getTarget().m_20206_() * 0.5, 0.0) : new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
    }

    @Nullable
    private Entity getTarget() {
        return this.targetId == -1 ? null : this.f_107208_.m_6815_(this.targetId);
    }

    protected float getRibbonHeight() {
        return this.ribbonHeight;
    }

    protected ResourceLocation getRibbonSprite() {
        return TEXTURE;
    }

    protected int totalSegments() {
        return 5;
    }
}

