/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item.book.books;

import dev.xylonity.companions.common.entity.projectile.HolinessNaginataProjectile;
import dev.xylonity.companions.common.item.book.AbstractMagicBook;
import dev.xylonity.companions.common.material.ArmorMaterials;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.List;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NaginataBook
extends AbstractMagicBook {
    public NaginataBook(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected String tooltipName() {
        return "naginata_book";
    }

    @Override
    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        components.add((Component)Component.m_237115_((String)"tooltip.item.companions.naginata_book_2"));
        super.m_7373_(itemStack, level, components, flag);
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (!level.f_46443_) {
            AABB bb;
            Vec3 endPos;
            Vec3 eyePos = player.m_146892_();
            EntityHitResult entityHit = ProjectileUtil.m_37304_((Level)level, (Entity)player, (Vec3)eyePos, (Vec3)(endPos = eyePos.m_82549_(player.m_20154_().m_82490_(80.0))), (AABB)(bb = new AABB(eyePos, endPos).m_82400_(2.0)), e -> !Util.areEntitiesLinked((Entity)player, e));
            if (entityHit == null) {
                BlockHitResult blockHit = level.m_45547_(new ClipContext(eyePos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
                if (blockHit.m_6662_() == HitResult.Type.BLOCK) {
                    this.spawnNaginatas(player, blockHit.m_82450_(), level);
                }
            } else {
                this.spawnNaginatas(player, entityHit.m_82443_().m_20182_(), level);
            }
            player.m_36335_().m_41524_((Item)this, (int)((double)CompanionsConfig.NAGINATA_COOLDOWN * (1.0 - (double)Util.hasFullSetOn(player, ArmorMaterials.MAGE) * CompanionsConfig.MAGE_SET_COOLDOWN_REDUCTION)));
        }
        return super.m_7203_(level, player, hand);
    }

    @Override
    protected void playSound(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), CompanionsSounds.SPELL_RELEASE_SPEARS.get(), player.m_5720_(), 1.0f, 1.0f);
    }

    private void spawnNaginatas(Player player, Vec3 targetPos, Level level) {
        if (player.m_6144_()) {
            for (int i = 0; i < 2; ++i) {
                double dx = (new Random().nextDouble() - 0.5) * 20.0;
                double dz = (new Random().nextDouble() - 0.5) * 20.0;
                double x = targetPos.f_82479_ + dx;
                double z = targetPos.f_82481_ + dz;
                Vec3 spawnPos = new Vec3(x, 20.0 + targetPos.f_82480_ + new Random().nextDouble() * 10.0, z);
                this.spawnNaginata(player, spawnPos, targetPos, level, 3.35);
            }
        } else {
            for (int i = 0; i < 6; ++i) {
                double dx = (new Random().nextDouble() - 0.5) * 30.0;
                double dz = (new Random().nextDouble() - 0.5) * 30.0;
                double x = targetPos.f_82479_ + dx;
                double z = targetPos.f_82481_ + dz;
                Vec3 spawnPos = new Vec3(x, 20.0 + targetPos.f_82480_ + new Random().nextDouble() * 10.0, z);
                this.spawnNaginata(player, spawnPos, targetPos, level, 1.5 + new Random().nextDouble() * 0.5);
            }
        }
    }

    private void spawnNaginata(Player player, Vec3 spawnPos, Vec3 targetPos, Level level, double speed) {
        HolinessNaginataProjectile naginata = (HolinessNaginataProjectile)((EntityType)CompanionsEntities.HOLINESS_NAGINATA.get()).m_20615_(level);
        if (naginata != null) {
            naginata.m_5602_((Entity)player);
            naginata.m_6034_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
            naginata.m_20256_(targetPos.m_82546_(spawnPos).m_82541_().m_82490_(speed));
            naginata.refreshOrientation();
            naginata.m_6842_(true);
            level.m_7967_((Entity)naginata);
        }
    }
}

