/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item.book.books;

import dev.xylonity.companions.common.entity.projectile.MagicRayCircleProjectile;
import dev.xylonity.companions.common.entity.projectile.MagicRayPieceProjectile;
import dev.xylonity.companions.common.item.book.AbstractMagicBook;
import dev.xylonity.companions.common.material.ArmorMaterials;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.api.scheduler.TickScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MagicRayBook
extends AbstractMagicBook {
    public MagicRayBook(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected String tooltipName() {
        return "magic_ray_book";
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        if (!pLevel.f_46443_) {
            Vec3 dir = pPlayer.m_20154_();
            double traveled = 0.0;
            for (int i = 0; i < 30; ++i) {
                Vec3 piecePos = pPlayer.m_20299_(1.0f).m_82549_(dir).m_82549_(dir.m_82490_(traveled));
                traveled += 1.0;
                BlockPos blockPos = BlockPos.m_274446_((Position)piecePos);
                if (!this.isPassableBlock(pLevel, blockPos)) {
                    this.spawnRayPiece(pLevel, pPlayer, piecePos, dir, i == 0);
                    break;
                }
                this.spawnRayPiece(pLevel, pPlayer, piecePos, dir, i == 0);
            }
            pPlayer.m_36335_().m_41524_((Item)this, (int)((double)CompanionsConfig.MAGIC_RAY_COOLDOWN * (1.0 - (double)Util.hasFullSetOn(pPlayer, ArmorMaterials.MAGE) * CompanionsConfig.MAGE_SET_COOLDOWN_REDUCTION)));
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    @Override
    protected void playSound(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), CompanionsSounds.SPELL_RELEASE_BEAM.get(), player.m_5720_(), 1.2f, 1.0f);
    }

    private boolean isPassableBlock(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60812_((BlockGetter)level, pos).m_83281_();
    }

    private void spawnRayPiece(Level pLevel, Player pPlayer, Vec3 piecePos, Vec3 lookVec, boolean isFirstPiece) {
        if (isFirstPiece) {
            MagicRayCircleProjectile circle = (MagicRayCircleProjectile)((EntityType)CompanionsEntities.MAGIC_RAY_PIECE_CIRCLE_PROJECTILE.get()).m_20615_(pLevel);
            if (circle != null) {
                circle.m_6034_(piecePos.f_82479_, piecePos.f_82480_, piecePos.f_82481_);
                circle.m_5602_((Entity)pPlayer);
                this.rotateProjectile(circle, lookVec);
                pLevel.m_7967_((Entity)circle);
            }
        } else {
            MagicRayPieceProjectile ray = (MagicRayPieceProjectile)((EntityType)CompanionsEntities.MAGIC_RAY_PIECE_PROJECTILE.get()).m_20615_(pLevel);
            if (ray != null) {
                ray.m_6034_(piecePos.f_82479_, piecePos.f_82480_, piecePos.f_82481_);
                this.rotateProjectile(ray, lookVec);
                ray.m_5602_((Entity)pPlayer);
                if (pLevel instanceof ServerLevel) {
                    ServerLevel level = (ServerLevel)pLevel;
                    TickScheduler.scheduleServer((Level)level, () -> pLevel.m_7967_((Entity)ray), (int)3);
                }
            }
        }
    }

    private void rotateProjectile(MagicRayPieceProjectile projectile, Vec3 direction) {
        projectile.setPitch((float)(-Math.atan2(direction.f_82480_, Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_)) * 57.29577951308232));
        projectile.setYaw((float)(Math.atan2(direction.f_82481_, direction.f_82479_) * 57.29577951308232) - 90.0f);
    }
}

