/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import java.util.Random;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class TornadoProjectile
extends BaseProjectile {
    private final RawAnimation SPIN = RawAnimation.begin().thenPlay("spin");
    private static final EntityDataAccessor<Float> GROUNDY = SynchedEntityData.m_135353_(TornadoProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> STARTX = SynchedEntityData.m_135353_(TornadoProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> STARTZ = SynchedEntityData.m_135353_(TornadoProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ALPHA = SynchedEntityData.m_135353_(TornadoProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private boolean initialized = false;

    public TornadoProjectile(EntityType<? extends BaseProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GROUNDY, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(STARTX, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(STARTZ, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ALPHA, (Object)Float.valueOf(0.0f));
    }

    public float getGroundY() {
        return ((Float)this.f_19804_.m_135370_(GROUNDY)).floatValue();
    }

    public void setGroundY(float v) {
        this.f_19804_.m_135381_(GROUNDY, (Object)Float.valueOf(v));
    }

    public float getStartX() {
        return ((Float)this.f_19804_.m_135370_(STARTX)).floatValue();
    }

    public void setStartX(float v) {
        this.f_19804_.m_135381_(STARTX, (Object)Float.valueOf(v));
    }

    public float getStartZ() {
        return ((Float)this.f_19804_.m_135370_(STARTZ)).floatValue();
    }

    public void setStartZ(float v) {
        this.f_19804_.m_135381_(STARTZ, (Object)Float.valueOf(v));
    }

    public float getAlpha() {
        return ((Float)this.f_19804_.m_135370_(ALPHA)).floatValue();
    }

    public void setAlpha(float v) {
        this.f_19804_.m_135381_(ALPHA, (Object)Float.valueOf(v));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Entity owner = this.m_19749_();
        if (!this.initialized) {
            this.setGroundY((float)this.m_20186_());
            this.setStartX((float)this.m_20185_());
            this.setStartZ((float)this.m_20189_());
            if (owner != null) {
                Vec3 ownerPos = owner.m_20299_(1.0f);
                Vec3 projPos = this.m_20182_();
                Vec3 dir = projPos.m_82546_(ownerPos).m_82541_();
                this.setAlpha((float)Math.atan2(dir.f_82481_, dir.f_82479_));
            } else {
                this.setAlpha(0.0f);
            }
            this.m_20242_(true);
            this.initialized = true;
        }
        if (this.f_19797_ >= this.getLifetime()) {
            this.onExpire();
            return;
        }
        double t = (double)this.f_19797_ * 0.2;
        double xLocal = Math.sin(0.5 * t) + t;
        double zLocal = Math.cos(0.5 * t);
        double cosA = Math.cos(this.getAlpha());
        double sinA = Math.sin(this.getAlpha());
        this.m_6034_((double)this.getStartX() + (xLocal * cosA - zLocal * sinA), this.getGroundY(), (double)this.getStartZ() + (xLocal * sinA + zLocal * cosA));
        this.m_9236_().m_6443_(Entity.class, this.m_20191_().m_82400_(1.0), e -> !Util.areEntitiesLinked((Entity)this, e)).forEach(e -> {
            Vec3 dir = e.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82490_(1.4);
            e.m_5997_(dir.f_82479_ + 0.1, dir.f_82480_ + 0.1, dir.f_82481_ + 0.1);
            if (e instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)e;
                living.m_6469_(this.m_269291_().m_269425_(), (float)CompanionsConfig.ICE_TORNADO_DAMAGE);
            }
        });
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sv = (ServerLevel)level;
            Random random = new Random();
            if ((double)random.nextFloat() <= 0.8) {
                sv.m_8767_((ParticleOptions)ParticleTypes.f_175821_, this.m_20185_() + (double)(this.m_20205_() * 2.0f) * Math.random(), this.m_20186_() + (double)(this.m_20206_() * 2.0f) * Math.random(), this.m_20189_() + (double)(this.m_20205_() * 2.0f) * Math.random(), 1, 0.0, 0.0, 0.0, 0.05);
            }
        }
        if (this.m_9236_().f_46443_ && (this.f_19797_ % 15 == 0 || this.f_19797_ == 1)) {
            for (int i = 0; i < 3; ++i) {
                float r = (float)(190 + this.m_9236_().f_46441_.m_188503_(30)) / 255.0f;
                float g = (float)(240 + this.m_9236_().f_46441_.m_188503_(10)) / 255.0f;
                float b = (float)(247 + this.m_9236_().f_46441_.m_188503_(5)) / 255.0f;
                Companions.PROXY.spawnBaseProjectileTrail((Entity)this, this.m_20205_() + this.m_9236_().f_46441_.m_188501_() * 0.6f, this.m_20206_() + this.m_9236_().f_46441_.m_188501_() * 0.5f, r, g, b);
            }
        }
    }

    private void onExpire() {
        if (this.m_9236_().f_46443_) {
            this.spawnHitParticles();
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_216990_(SoundEvents.f_144243_);
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void m_7822_(byte pId) {
        if (pId == 3) {
            this.spawnHitParticles();
        } else {
            super.m_7822_(pId);
        }
    }

    private void spawnHitParticles() {
        for (int i = 0; i < 10; ++i) {
            double x = this.m_20185_() + (double)(this.m_20205_() * 2.0f) * Math.random();
            double y = this.m_20186_() + (double)(this.m_20206_() * 2.0f) * Math.random();
            double z = this.m_20189_() + (double)(this.m_20205_() * 2.0f) * Math.random();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, x, y, z, 0.05, 0.05, 0.05);
        }
    }

    protected void m_6532_(@NotNull HitResult pResult) {
        BlockHitResult blockHit;
        Direction hitDirection;
        if (pResult instanceof BlockHitResult && ((hitDirection = (blockHit = (BlockHitResult)pResult).m_82434_()) == Direction.UP || hitDirection == Direction.DOWN)) {
            return;
        }
        if (this.m_9236_().f_46443_) {
            this.spawnHitParticles();
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_216990_(SoundEvents.f_144245_);
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void m_6123_(@NotNull Player pEntity) {
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", this::predicate)});
    }

    @Override
    protected int baseLifetime() {
        return 120;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.getController().setAnimation(this.SPIN);
        return PlayState.CONTINUE;
    }
}

