/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SmallIceShardProjectile
extends AbstractArrow
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final int PHASE_1_DURATION = 20;
    private static final double PHASE_1_FRICTION = 0.95;
    private static final double PHASE_2_FRICTION = 0.88;
    private static final double PHASE_2_ACCELERATION = 0.04;
    private static final int LIFETIME = 200;
    private LivingEntity target;
    private boolean followOwnerLook = false;
    private final Quaternionf prevRotation = new Quaternionf();
    private final Quaternionf currentRotation = new Quaternionf();

    public SmallIceShardProjectile(EntityType<? extends AbstractArrow> type, Level level) {
        super(type, level);
        Vec3 randomDir = new Vec3(this.f_19796_.m_188500_() * 2.0 - 1.0, this.f_19796_.m_188500_() * 2.0 - 1.0, this.f_19796_.m_188500_() * 2.0 - 1.0).m_82541_();
        this.m_20256_(randomDir.m_82490_(0.2));
        this.m_20242_(true);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    public void setTarget(@Nullable LivingEntity target) {
        this.target = target;
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.target;
    }

    protected boolean m_5603_(@NotNull Entity entity) {
        if (Util.areEntitiesLinked(entity, (Entity)this)) {
            return false;
        }
        return super.m_5603_(entity);
    }

    public void m_8119_() {
        Entity targetPos;
        super.m_8119_();
        if (this.target != null) {
            if (this.f_19797_ < 20) {
                this.m_20256_(this.m_20184_().m_82490_(0.95));
            } else {
                targetPos = new Vec3(this.target.m_20185_(), this.target.m_20186_() + (double)this.target.m_20206_() * 0.7, this.target.m_20189_());
                Vec3 diff = targetPos.m_82546_(this.m_20182_());
                Vec3 newVel = this.m_20184_().m_82490_(0.88).m_82549_(diff.m_82541_().m_82490_(0.04));
                this.m_20256_(newVel);
            }
        } else if (this.followOwnerLook && (targetPos = this.m_19749_()) instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)targetPos;
            if (this.f_19797_ < 20) {
                this.m_20256_(this.m_20184_().m_82490_(0.95));
            } else {
                targetPos = owner.m_20154_().m_82541_();
                Vec3 newVel = this.m_20184_().m_82490_(0.88).m_82549_(targetPos.m_82490_(0.04));
                this.m_20256_(newVel);
            }
        }
        this.updateRotations();
        if (this.f_19797_ == 200) {
            if (this.m_9236_().f_46443_) {
                this.spawnHitParticles();
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)3);
                this.m_216990_(SoundEvents.f_276532_);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (this.m_9236_().f_46443_ && (this.f_19797_ % 40 == 0 || this.f_19797_ == 1)) {
            float r = (float)(190 + this.m_9236_().f_46441_.m_188503_(30)) / 255.0f;
            float g = (float)(240 + this.m_9236_().f_46441_.m_188503_(10)) / 255.0f;
            float b = (float)(247 + this.m_9236_().f_46441_.m_188503_(5)) / 255.0f;
            Companions.PROXY.spawnBaseProjectileTrail((Entity)this, 0.0f, this.m_20206_() * 0.5f, r, g, b);
        }
    }

    private void updateRotations() {
        Vec3 vel = this.m_20184_();
        if (vel.m_82556_() <= 1.0E-7) {
            return;
        }
        this.prevRotation.set((Quaternionfc)this.currentRotation);
        Vector3f velVec = new Vector3f((float)vel.f_82479_, (float)vel.f_82480_, (float)vel.f_82481_).normalize();
        Vector3f forward = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f axis = forward.cross((Vector3fc)velVec);
        if (axis.length() < 1.0E-4f) {
            axis.set(0.0f, 1.0f, 0.0f);
        } else {
            axis.normalize();
        }
        float dot = Math.max(-1.0f, Math.min(1.0f, forward.dot((Vector3fc)velVec)));
        Quaternionf targetRot = new Quaternionf().fromAxisAngleRad((Vector3fc)axis, (float)Math.acos(dot));
        if (this.f_19797_ < 20) {
            this.currentRotation.set((Quaternionfc)targetRot);
        } else {
            this.currentRotation.slerp((Quaternionfc)targetRot, 0.5f);
        }
    }

    protected void m_6532_(@NotNull HitResult pResult) {
        if (pResult.m_6662_().equals((Object)HitResult.Type.ENTITY)) {
            TamableAnimal t;
            Entity target = ((EntityHitResult)pResult).m_82443_();
            if (target.equals((Object)this.m_19749_()) || target instanceof TamableAnimal && (t = (TamableAnimal)target).m_269323_() != null && t.m_269323_().equals((Object)this.m_19749_())) {
                return;
            }
            target.m_6469_(this.m_269291_().m_269425_(), (float)CompanionsConfig.SMALL_ICE_SHARD_DAMAGE);
            target.m_146917_(target.m_146888_() + CompanionsConfig.SMALL_ICE_SHARD_FREEZE_TICKS);
        }
        if (this.m_9236_().f_46443_) {
            this.spawnHitParticles();
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_216990_(SoundEvents.f_144245_);
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void m_7822_(byte pId) {
        if (pId == 3) {
            this.spawnHitParticles();
        } else {
            super.m_7822_(pId);
        }
    }

    public void setFollowOwnerLook(boolean ownerLook) {
        this.followOwnerLook = ownerLook;
    }

    public void shootTowards(Vec3 dir, double speed) {
        this.m_20256_(dir.m_82541_().m_82490_(speed));
    }

    public Quaternionf getPrevRotation() {
        return this.prevRotation;
    }

    public Quaternionf getCurrentRotation() {
        return this.currentRotation;
    }

    private void spawnHitParticles() {
        for (int i = 0; i < 5; ++i) {
            double dx = (this.m_9236_().m_213780_().m_188500_() - 0.5) * 0.1;
            double dy = (this.m_9236_().m_213780_().m_188500_() - 0.5) * 0.1;
            double dz = (this.m_9236_().m_213780_().m_188500_() - 0.5) * 0.1;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, this.m_20185_(), this.m_20186_(), this.m_20189_(), dx, dy, dz);
            if (i % 2 != 0) continue;
            this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_41980_)), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.5, this.m_20189_(), dx, dy, dz);
        }
    }

    protected boolean m_142470_(@NotNull Player p) {
        return false;
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public void m_6123_(@NotNull Player p) {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar r) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

