/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.projectile.SmallIceShardProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsEntities;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BigIceShardProjectile
extends AbstractArrow
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final int LIFETIME = 25;
    private static final double RAY_DISTANCE = 64.0;
    private static final double SMALL_SHARD_SPEED = 0.4;
    private static final RawAnimation APPEAR = RawAnimation.begin().thenPlay("appear");
    private LivingEntity target;

    public BigIceShardProjectile(EntityType<? extends AbstractArrow> type, Level level) {
        super(type, level);
        double minElevation = Math.toRadians(30.0);
        double elevation = minElevation + this.f_19796_.m_188500_() * (Math.toRadians(90.0) - minElevation);
        double t = this.f_19796_.m_188500_() * Math.PI * 2.0;
        double dx = Math.cos(elevation) * Math.cos(t);
        double dy = Math.sin(elevation);
        double dz = Math.cos(elevation) * Math.sin(t);
        this.m_20256_(new Vec3(dx, dy, dz).m_82541_().m_82490_(4.0));
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    protected boolean m_5603_(@NotNull Entity entity) {
        if (Util.areEntitiesLinked(entity, (Entity)this)) {
            return false;
        }
        return super.m_5603_(entity);
    }

    public void setTarget(@Nullable LivingEntity tgt) {
        this.target = tgt;
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.target;
    }

    public void m_8119_() {
        super.m_8119_();
        Entity owner = this.m_19749_();
        if (owner != null) {
            this.m_20242_(true);
            if (this.f_19797_ < 25) {
                this.m_20256_(this.m_20184_().m_82490_(0.95));
            }
            if (this.f_19797_ == 25) {
                if (this.m_9236_().f_46443_) {
                    this.spawnHitParticles();
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)3);
                    this.m_216990_(SoundEvents.f_276532_);
                }
                for (int i = 0; i < 5; ++i) {
                    SmallIceShardProjectile shard = (SmallIceShardProjectile)((EntityType)CompanionsEntities.SMALL_ICE_SHARD_PROJECTILE.get()).m_20615_(this.m_9236_());
                    if (shard == null) continue;
                    shard.m_6027_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    shard.m_5602_(owner);
                    LivingEntity target1 = this.getTarget();
                    if (target1 == null && owner instanceof LivingEntity) {
                        LivingEntity livingOwner = (LivingEntity)owner;
                        target1 = BigIceShardProjectile.findEntityInCrosshair(livingOwner);
                    }
                    if (target1 != null) {
                        shard.setTarget(target1);
                    } else {
                        shard.setFollowOwnerLook(true);
                        shard.shootTowards(BigIceShardProjectile.genRandomShardDir(owner instanceof LivingEntity ? owner.m_20154_() : this.m_20184_().m_82541_()), 0.4);
                    }
                    this.m_9236_().m_7967_((Entity)shard);
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    @Nullable
    private static LivingEntity findEntityInCrosshair(LivingEntity player) {
        AABB bb = player.m_20191_().m_82369_(player.m_20154_().m_82490_(64.0)).m_82400_(1.0);
        EntityHitResult hit = ProjectileUtil.m_37304_((Level)player.m_9236_(), (Entity)player, (Vec3)player.m_146892_(), (Vec3)player.m_146892_().m_82549_(player.m_20154_().m_82490_(64.0)), (AABB)bb, e -> e instanceof LivingEntity && e != player);
        return hit != null ? (LivingEntity)hit.m_82443_() : null;
    }

    private static Vec3 genRandomShardDir(Vec3 dir) {
        Random random = new Random();
        Vec3 forward = dir.m_82541_();
        Vec3 up = Math.abs(forward.m_82526_(new Vec3(0.0, 1.0, 0.0))) > 0.99 ? new Vec3(1.0, 0.0, 0.0) : new Vec3(0.0, 1.0, 0.0);
        Vec3 right = forward.m_82537_(up).m_82541_();
        up = right.m_82537_(forward).m_82541_();
        double maxRad = Math.toRadians(8.0);
        double ct = random.nextDouble() * (1.0 - Math.cos(maxRad)) + Math.cos(maxRad);
        double st = Math.sqrt(1.0 - ct * ct);
        double ph = random.nextDouble() * Math.PI * 2.0;
        return forward.m_82490_(ct).m_82549_(right.m_82490_(st * Math.cos(ph))).m_82549_(up.m_82490_(st * Math.sin(ph))).m_82541_();
    }

    private void spawnHitParticles() {
        for (int i = 0; i < 10; ++i) {
            double dx = (this.m_9236_().m_213780_().m_188500_() - 0.5) * 0.1;
            double dy = (this.m_9236_().m_213780_().m_188500_() - 0.5) * 0.1;
            double dz = (this.m_9236_().m_213780_().m_188500_() - 0.5) * 0.1;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, this.m_20185_(), this.m_20186_(), this.m_20189_(), dx, dy, dz);
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 3) {
            this.spawnHitParticles();
        } else {
            super.m_7822_(pId);
        }
    }

    @NotNull
    protected SoundEvent m_7239_() {
        return SoundEvents.f_144245_;
    }

    protected boolean m_142470_(@NotNull Player pPlayer) {
        return false;
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public void m_6123_(@NotNull Player pPlayer) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.f_19797_ <= 8) {
            event.getController().setAnimation(APPEAR);
        }
        return PlayState.CONTINUE;
    }
}

