/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.hostile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.HostileEntity;
import dev.xylonity.companions.common.entity.ai.pontiff.goal.HolinessDoubleThrowAttackGoal;
import dev.xylonity.companions.common.entity.ai.pontiff.goal.HolinessImpactAttackGoal;
import dev.xylonity.companions.common.entity.ai.pontiff.goal.HolinessMeleeAttackGoal;
import dev.xylonity.companions.common.entity.ai.pontiff.goal.HolinessStakeAttackGoal;
import dev.xylonity.companions.common.entity.ai.pontiff.goal.HolinessStarAttackGoal;
import dev.xylonity.companions.common.entity.ai.pontiff.goal.PontiffDashAttackGoal;
import dev.xylonity.companions.common.entity.ai.pontiff.goal.PontiffMeleeAttackGoal;
import dev.xylonity.companions.common.entity.ai.pontiff.goal.PontiffNearestAttackableTargetGoal;
import dev.xylonity.companions.common.entity.ai.pontiff.goal.PontiffRotatingFireRayGoal;
import dev.xylonity.companions.common.entity.ai.pontiff.goal.PontiffStaffKnockAttackGoal;
import dev.xylonity.companions.common.entity.ai.pontiff.goal.PontiffStrafeAroundTargetGoal;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.api.music.IBossMusicProvider;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class SacredPontiffEntity
extends HostileEntity
implements IBossMusicProvider {
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation INACTIVE = RawAnimation.begin().thenPlay("inactive");
    private final RawAnimation ACTIVATE = RawAnimation.begin().thenPlay("activate");
    private final RawAnimation UP_ATTACK = RawAnimation.begin().thenPlay("up_attack");
    private final RawAnimation FRONT_ATTACK = RawAnimation.begin().thenPlay("front_attack");
    private final RawAnimation HOLD_ATTACK = RawAnimation.begin().thenPlay("hold_attack");
    private final RawAnimation AREA_ATTACK = RawAnimation.begin().thenPlay("area_attack");
    private final RawAnimation TRANSFORMATION = RawAnimation.begin().thenPlay("transformation");
    private final RawAnimation APPEAR = RawAnimation.begin().thenPlay("appear");
    private final RawAnimation STAB = RawAnimation.begin().thenPlay("stab");
    private final RawAnimation STAKE = RawAnimation.begin().thenPlay("stake");
    private final RawAnimation DOUBLE_THROW = RawAnimation.begin().thenPlay("double_throw");
    private final RawAnimation IMPACT = RawAnimation.begin().thenPlay("impact");
    private final RawAnimation STAR_ATTACK = RawAnimation.begin().thenPlay("star_attack");
    private final RawAnimation PHASE2_DIE = RawAnimation.begin().thenPlay("die");
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(SacredPontiffEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STATE_COUNTER = SynchedEntityData.m_135353_(SacredPontiffEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.m_135353_(SacredPontiffEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> APPEAR_ANIMATION = SynchedEntityData.m_135353_(SacredPontiffEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOULD_ATTACK = SynchedEntityData.m_135353_(SacredPontiffEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOULD_LOOK_AT_TARGET = SynchedEntityData.m_135353_(SacredPontiffEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int ANIMATION_ACTIVATION_MAX_TICKS = 65;
    private static final int ANIMATION_PHASE2_DEAD_MAX_TICKS = 153;
    private static final int ANIMATION_PHASE1_DEAD_MAX_TICKS = 166;
    private static final int ANIMATION_PHASE2_APPEAR_MAX_TICKS = 158;
    private static final int INVISIBLE_MAX_TICKS = 60;
    private boolean hasRegisteredBossBar = false;
    private int attackCounter;
    private int lastAttackType;
    private int transformationCounter;
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    private static final Set<Integer> SHAKE_TICKS = Set.of(Integer.valueOf(70), Integer.valueOf(80), Integer.valueOf(93), Integer.valueOf(104), Integer.valueOf(117), Integer.valueOf(128), Integer.valueOf(159));

    public SacredPontiffEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19811_ = true;
        this.setNoMovement(true);
        this.m_274367_(1.0f);
        this.bossInfo.m_7006_(true);
        this.attackCounter = 0;
        this.lastAttackType = 0;
        this.transformationCounter = 0;
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PontiffRotatingFireRayGoal(this, 200, 500));
        this.f_21345_.m_25352_(1, (Goal)new PontiffMeleeAttackGoal(this, 10, 60));
        this.f_21345_.m_25352_(1, (Goal)new PontiffStaffKnockAttackGoal(this, 160, 360));
        this.f_21345_.m_25352_(1, (Goal)new PontiffDashAttackGoal(this, 60, 200));
        this.f_21345_.m_25352_(1, (Goal)new HolinessMeleeAttackGoal(this, 40, 100));
        this.f_21345_.m_25352_(1, (Goal)new HolinessStakeAttackGoal(this, 60, 140));
        this.f_21345_.m_25352_(1, (Goal)new HolinessDoubleThrowAttackGoal(this, 200, 700));
        this.f_21345_.m_25352_(1, (Goal)new HolinessImpactAttackGoal(this, 160, 600));
        this.f_21345_.m_25352_(1, (Goal)new HolinessStarAttackGoal(this, 200, 500));
        this.f_21345_.m_25352_(2, (Goal)new PontiffStrafeAroundTargetGoal(this, 0.5, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean m_8036_() {
                return super.m_8036_() && SacredPontiffEntity.this.shouldSearchTarget();
            }
        });
        this.f_21346_.m_25352_(2, new PontiffNearestAttackableTargetGoal<Player>(this, Player.class, true));
        this.f_21346_.m_25352_(2, new PontiffNearestAttackableTargetGoal<TamableAnimal>(this, TamableAnimal.class, true));
        this.f_21346_.m_25352_(2, new PontiffNearestAttackableTargetGoal<Turtle>(this, Turtle.class, true));
    }

    @Override
    public void m_8119_() {
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.getState() == 2 && !this.hasRegisteredBossBar) {
            this.hasRegisteredBossBar = true;
            this.bossInfo.m_6456_(this.m_5446_());
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (ServerPlayer p : serverLevel.m_8795_(p2 -> true)) {
                    if (!(p.m_20280_((Entity)this) < 4096.0)) continue;
                    this.bossInfo.m_6543_(p);
                }
            }
        }
        if (this.getState() == 5) {
            this.m_5634_(this.m_21233_() / 158.0f);
        }
        if (this.m_146888_() > 0) {
            this.m_146917_(0);
        }
        if (this.m_21023_(MobEffects.f_19620_)) {
            this.m_21195_(MobEffects.f_19620_);
        }
        if (this.getState() >= 3 && this.getState() <= 5) {
            if (this.getState() == 3) {
                if (this.m_9236_().f_46443_ && this.transformationCounter == 130) {
                    for (Player player : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(30.0))) {
                        if (!this.m_9236_().f_46443_) continue;
                        Companions.PROXY.shakePlayerCamera(player, 50, 0.045f, 0.045f, 0.045f, 30);
                    }
                } else if (!this.m_9236_().f_46443_ && this.transformationCounter == 120) {
                    this.m_5496_(CompanionsSounds.PONTIFF_DESPAWN.get(), 0.5f, 1.0f);
                }
            }
            if (this.getState() == 5 && !this.m_9236_().f_46443_ && this.transformationCounter == 15) {
                this.m_5496_(CompanionsSounds.HOLINESS_APPEAR.get(), 0.5f, 1.0f);
            }
            ++this.transformationCounter;
        }
        if (this.getState() >= 5 && this.getAttackType() == 4) {
            if (this.m_9236_().f_46443_ && this.attackCounter == 35) {
                for (Player player : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(30.0))) {
                    if (!this.m_9236_().f_46443_) continue;
                    Companions.PROXY.shakePlayerCamera(player, 50, 0.045f, 0.045f, 0.045f, 30);
                }
            } else if (!this.m_9236_().f_46443_ && this.attackCounter == 35) {
                this.m_5496_(CompanionsSounds.HOLINESS_HIT_GROUND.get(), 14.0f, 1.0f);
            }
        }
        if (this.getState() == 5 && SHAKE_TICKS.contains(this.getStateCounter())) {
            for (Player player : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(30.0))) {
                if (this.m_9236_().f_46443_) {
                    Companions.PROXY.shakePlayerCamera(player, 5, 0.1f, 0.1f, 0.1f, 10);
                    continue;
                }
                this.m_5496_(CompanionsSounds.HOLINESS_HIT_CHEST.get(), 2.0f, 1.0f);
            }
        }
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.stateMachine();
        }
        if (this.getAttackType() != 0) {
            if (this.getAttackType() != this.lastAttackType) {
                this.lastAttackType = this.getAttackType();
                this.attackCounter = 0;
            }
            ++this.attackCounter;
        } else {
            this.attackCounter = 0;
        }
    }

    public void m_5997_(double pX, double pY, double pZ) {
    }

    private void stateMachine() {
        if (this.getState() == 1) {
            if (this.getStateCounter() == -1) {
                this.setStateCounter(0);
            }
            if (this.getStateCounter() == 65) {
                this.cycleState();
                this.setNoMovement(false);
            }
        } else if (this.getState() == 3) {
            if (this.getStateCounter() == -1) {
                this.setStateCounter(0);
            }
            if (this.getStateCounter() == 166) {
                this.cycleState();
                this.m_6842_(true);
                this.bossInfo.m_6456_((Component)Component.m_237115_((String)"entity.companions.sacred_pontiff_invisible"));
            }
        } else if (this.getState() == 4) {
            if (this.getStateCounter() == -1) {
                this.setStateCounter(0);
            }
            if (this.getStateCounter() == 60) {
                AttributeInstance newDmg;
                this.cycleState();
                this.bossInfo.m_6456_(this.m_7755_());
                AttributeInstance maxHealth = this.m_21051_(Attributes.f_22276_);
                if (maxHealth != null) {
                    maxHealth.m_22100_(CompanionsConfig.HIS_HOLINESS_MAX_LIFE);
                }
                if ((newDmg = this.m_21051_(Attributes.f_22281_)) != null) {
                    newDmg.m_22100_(CompanionsConfig.HIS_HOLINESS_DAMAGE);
                }
            }
        } else if (this.getState() == 5) {
            if (this.getStateCounter() == -1) {
                this.setStateCounter(0);
            }
            if (this.getStateCounter() == 2) {
                this.m_6842_(false);
            }
            if (this.getStateCounter() == 158) {
                this.cycleState();
                this.setNoMovement(false);
            }
        }
        if (this.getStateCounter() != -1 && this.getState() != 0) {
            this.setStateCounter(this.getStateCounter() + 1);
        }
    }

    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return CompanionsSounds.PONTIFF_HURT.get();
    }

    protected SoundEvent m_7515_() {
        return CompanionsSounds.PONTIFF_IDLE.get();
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.m_5496_(CompanionsSounds.PONTIFF_STEP.get(), 0.55f, 1.0f);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, CompanionsConfig.SACRED_PONTIFF_MAX_LIFE).m_22268_(Attributes.f_22281_, CompanionsConfig.SACRED_PONTIFF_DAMAGE).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.45f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_6457_(@NotNull ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        if (this.getState() >= 1) {
            this.bossInfo.m_6543_(pPlayer);
        }
    }

    public void m_6452_(@NotNull ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossInfo.m_6539_(pPlayer);
    }

    public int getStateCounter() {
        return (Integer)this.f_19804_.m_135370_(STATE_COUNTER);
    }

    public void setStateCounter(int counter) {
        this.f_19804_.m_135381_(STATE_COUNTER, (Object)counter);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    public int getState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public void cycleState() {
        this.f_19804_.m_135381_(STATE, (Object)(this.getState() + 1));
        this.setStateCounter(-1);
        this.transformationCounter = 0;
    }

    public void setState(int state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    public boolean shouldSearchTarget() {
        return this.getState() == 2 || this.getState() == 6;
    }

    public boolean shouldAttack() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_ATTACK);
    }

    public boolean shouldLookAtTarget() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_LOOK_AT_TARGET);
    }

    public void setShouldLookAtTarget(boolean shouldLookAtTarget) {
        this.f_19804_.m_135381_(SHOULD_LOOK_AT_TARGET, (Object)shouldLookAtTarget);
    }

    public int getAttackType() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TYPE);
    }

    public void setAttackType(int type) {
        this.f_19804_.m_135381_(ATTACK_TYPE, (Object)type);
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (this.getState() == 0) {
            this.cycleState();
            this.m_216990_(CompanionsSounds.PONTIFF_ACTIVATE.get());
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        if (this.getState() == 0 || this.getState() == 1 || this.getState() == 3 || this.getState() == 4 || this.getState() == 5) {
            return false;
        }
        if (this.m_21223_() - pAmount <= 0.0f && this.getState() == 2) {
            this.cycleState();
            this.m_216990_(CompanionsSounds.PONTIFF_GROUND_DESPAWN.get());
            this.m_21153_(0.1f);
            this.setNoMovement(true);
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_147240_(double pStrength, double pX, double pZ) {
    }

    @NotNull
    public Component m_7755_() {
        if (this.getState() >= 5) {
            return Component.m_237115_((String)"entity.companions.his_holiness");
        }
        return Component.m_237115_((String)"entity.companions.sacred_pontiff");
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 1 && !this.m_9236_().f_46443_) {
            this.setNoMovement(true);
            this.m_5496_(CompanionsSounds.HOLINESS_DEATH.get(), 2.0f, 1.0f);
        }
        if (this.f_20919_ >= 153 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_19983_(new ItemStack((ItemLike)CompanionsItems.RELIC_GOLD.get(), this.m_217043_().m_216339_(2, 10)));
            this.m_19983_(new ItemStack((ItemLike)CompanionsItems.OLD_CLOTH.get(), this.m_217043_().m_216339_(2, 10)));
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)0);
        this.f_19804_.m_135372_(STATE_COUNTER, (Object)-1);
        this.f_19804_.m_135372_(ATTACK_TYPE, (Object)0);
        this.f_19804_.m_135372_(APPEAR_ANIMATION, (Object)false);
        this.f_19804_.m_135372_(SHOULD_ATTACK, (Object)true);
        this.f_19804_.m_135372_(SHOULD_LOOK_AT_TARGET, (Object)true);
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        return this.getState() <= 3 ? super.m_6972_(pPose) : EntityDimensions.m_20395_((float)1.0f, (float)2.0f);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("State")) {
            this.setState(pCompound.m_128451_("State"));
        }
        if (pCompound.m_128441_("IsInvisible")) {
            this.m_6842_(pCompound.m_128471_("IsInvisible"));
        }
        this.bossInfo.m_6456_(this.m_5446_());
        this.setStateCounter(-1);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("State", this.getState());
        pCompound.m_128405_("StateCounter", this.getStateCounter());
        pCompound.m_128379_("IsInvisible", this.m_20145_());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getState() >= 5) {
            if (this.m_21224_()) {
                event.setAnimation(this.PHASE2_DIE);
            } else if (this.getState() == 5) {
                event.setAnimation(this.APPEAR);
            } else if (this.getAttackType() == 1) {
                event.setAnimation(this.STAB);
            } else if (this.getAttackType() == 2) {
                event.setAnimation(this.STAKE);
            } else if (this.getAttackType() == 3) {
                event.setAnimation(this.DOUBLE_THROW);
            } else if (this.getAttackType() == 4) {
                event.setAnimation(this.IMPACT);
            } else if (this.getAttackType() == 5) {
                event.setAnimation(this.STAR_ATTACK);
            } else if (event.isMoving()) {
                event.setAnimation(this.WALK);
            } else {
                event.setAnimation(this.IDLE);
            }
        } else if (this.getState() == 0) {
            event.setAnimation(this.INACTIVE);
        } else if (this.getState() == 1) {
            event.setAnimation(this.ACTIVATE);
        } else if (this.getState() == 3) {
            event.setAnimation(this.TRANSFORMATION);
        } else if (this.getAttackType() == 1) {
            event.setAnimation(this.UP_ATTACK);
        } else if (this.getAttackType() == 2) {
            event.setAnimation(this.FRONT_ATTACK);
        } else if (this.getAttackType() == 3) {
            event.setAnimation(this.HOLD_ATTACK);
        } else if (this.getAttackType() == 4) {
            event.setAnimation(this.AREA_ATTACK);
        } else if (event.isMoving()) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    @NotNull
    public SoundEvent getBossMusic() {
        return CompanionsSounds.SAINT_KLIMT.get();
    }

    public boolean shouldPlayBossMusic(Player listener) {
        if (!this.m_6084_()) {
            return false;
        }
        if (this.getState() < 2) {
            return false;
        }
        return !(this.m_20280_((Entity)listener) > this.getMusicRangeSqr());
    }
}

