/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.hostile;

import dev.xylonity.companions.common.entity.companion.PuppetGloveEntity;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.api.scheduler.TickScheduler;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HostilePuppetGloveEntity
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation BROOM_IDLE = RawAnimation.begin().thenPlay("broom_idle");
    private final RawAnimation BROOM_DROP = RawAnimation.begin().thenPlay("broom_drop");
    private final RawAnimation BROOM_PICKUP = RawAnimation.begin().thenPlay("broom_pickup");
    private final RawAnimation GAME_IDLE = RawAnimation.begin().thenPlay("game_idle");
    private final RawAnimation GAME_SCISSORS = RawAnimation.begin().thenPlay("game_scissors");
    private final RawAnimation GAME_ROCK = RawAnimation.begin().thenPlay("game_rock");
    private final RawAnimation GAME_PAPER = RawAnimation.begin().thenPlay("game_paper");
    private final RawAnimation GAME_ATTACK = RawAnimation.begin().thenPlay("game_attack");
    private final RawAnimation GAME_LOOSE = RawAnimation.begin().thenPlay("game_loose");
    private final RawAnimation GAME_TAME = RawAnimation.begin().thenPlay("game_tame");
    private static final EntityDataAccessor<Boolean> IS_PLAYING = SynchedEntityData.m_135353_(HostilePuppetGloveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> GLOVE_MOVE = SynchedEntityData.m_135353_(HostilePuppetGloveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BROOM_PHASE = SynchedEntityData.m_135353_(HostilePuppetGloveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public UUID playingPlayerUUID = null;
    private long gameAutoStop = 0L;
    private long roundsLost = 0L;

    public HostilePuppetGloveEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 160.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 0.01f){

            public boolean m_8036_() {
                Mob mob = this.f_25512_;
                if (mob instanceof HostilePuppetGloveEntity) {
                    HostilePuppetGloveEntity glove = (HostilePuppetGloveEntity)mob;
                    return glove.playingPlayerUUID != null && super.m_8036_();
                }
                return super.m_8036_();
            }
        });
    }

    public void m_8119_() {
        double lastX = this.m_20185_();
        double lastZ = this.m_20189_();
        super.m_8119_();
        if (!((long)this.f_19797_ <= this.gameAutoStop || this.isPlaying() && this.getGloveMove() != 0 || !this.isPlaying() && this.getBroomPhase() != 0 || this.playingPlayerUUID == null)) {
            this.setIsPlaying(false);
            this.setBroomPhase(2);
            TickScheduler.scheduleServer((Level)this.m_9236_(), () -> this.setBroomPhase(0), (int)20);
            this.playingPlayerUUID = null;
        }
        if (this.f_19797_ % 15 == 0 && !this.m_9236_().f_46443_ && this.getBroomPhase() == 0 && !this.isPlaying()) {
            this.m_5496_(CompanionsSounds.HOSTILE_PUPPET_GLOVE_CLEAN.get(), 0.5f, 1.0f);
        }
        this.m_6034_(lastX, this.m_20186_(), lastZ);
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (this.isPlaying() && this.getGloveMove() != 0 || !this.isPlaying() && this.getBroomPhase() != 0) {
            return InteractionResult.FAIL;
        }
        Vec3 entityEyePos = this.m_20182_().m_82520_(0.0, (double)this.m_20192_(), 0.0);
        Vec3 playerEyePos = pPlayer.m_20182_().m_82520_(0.0, (double)pPlayer.m_20192_(), 0.0);
        if (this.m_20154_().m_82526_(playerEyePos.m_82546_(entityEyePos).m_82541_()) < Math.cos(Math.toRadians(45.0))) {
            return InteractionResult.FAIL;
        }
        if (this.isPlaying()) {
            int res;
            if (!pPlayer.m_20148_().equals(this.playingPlayerUUID)) {
                return InteractionResult.FAIL;
            }
            ItemStack stack = pPlayer.m_21120_(pHand);
            if (!this.isValidItem(stack)) {
                pPlayer.m_5661_((Component)Component.m_237115_((String)"hostile_puppet_glove.companions.client_message.wrong_item"), true);
                return InteractionResult.FAIL;
            }
            if (this.m_9236_() instanceof ServerLevel) {
                this.setGloveMove(this.f_19796_.m_216339_(1, 4));
            }
            if ((res = this.doesThePlayerWin(this.getPlayerMoveFromItem(stack), this.getGloveMove())) == 0) {
                TickScheduler.scheduleServer((Level)this.m_9236_(), () -> this.setGloveMove(0), (int)20);
                pPlayer.m_5661_((Component)Component.m_237115_((String)"hostile_puppet_glove.companions.client_message.draw"), true);
            } else if (res == 1) {
                TickScheduler.scheduleServer((Level)this.m_9236_(), () -> this.setGloveMove(4), (int)20);
                TickScheduler.scheduleServer((Level)this.m_9236_(), () -> this.m_216990_(CompanionsSounds.HOSTILE_PUPPET_GLOVE_ATTACK.get()), (int)20);
                List list = this.m_9236_().m_45976_(Player.class, new AABB(this.m_20183_()).m_82400_(4.0));
                if (list.contains(pPlayer) && HostilePuppetGloveEntity.isEntityInFront((LivingEntity)this, (Entity)pPlayer, 120.0)) {
                    TickScheduler.scheduleServer((Level)this.m_9236_(), () -> this.m_7327_((Entity)pPlayer), (int)25);
                }
                TickScheduler.scheduleServer((Level)this.m_9236_(), () -> this.setGloveMove(0), (int)30);
                pPlayer.m_5661_((Component)Component.m_237115_((String)"hostile_puppet_glove.companions.client_message.glove_wins"), true);
            } else if (this.roundsLost != 3L) {
                TickScheduler.scheduleServer((Level)this.m_9236_(), () -> this.setGloveMove(5), (int)20);
                TickScheduler.scheduleServer((Level)this.m_9236_(), () -> this.m_216990_(CompanionsSounds.HOSTILE_PUPPET_GLOVE_LOOSE.get()), (int)20);
                TickScheduler.scheduleServer((Level)this.m_9236_(), () -> this.setGloveMove(0), (int)53);
                pPlayer.m_5661_((Component)Component.m_237115_((String)"hostile_puppet_glove.companions.client_message.player_wins_round"), true);
                ++this.roundsLost;
            } else {
                TickScheduler.scheduleServer((Level)this.m_9236_(), () -> this.setGloveMove(6), (int)20);
                TickScheduler.scheduleServer((Level)this.m_9236_(), () -> {
                    PuppetGloveEntity glove = (PuppetGloveEntity)((EntityType)CompanionsEntities.PUPPET_GLOVE.get()).m_20615_(this.m_9236_());
                    if (glove != null) {
                        for (int i = 0; i < 50; ++i) {
                            double dx = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                            double dy = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                            double dz = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                            Level patt9556$temp = this.m_9236_();
                            if (!(patt9556$temp instanceof ServerLevel)) continue;
                            ServerLevel level = (ServerLevel)patt9556$temp;
                            level.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.5, this.m_20189_(), 1, dx, dy, dz, 0.1);
                        }
                        glove.m_21828_(pPlayer);
                        glove.m_20219_(this.m_20183_().m_252807_());
                        glove.m_146926_(this.m_146909_());
                        glove.m_146922_(this.m_146908_());
                        this.m_9236_().m_7967_((Entity)glove);
                    }
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }, (int)64);
                pPlayer.m_5661_((Component)Component.m_237115_((String)"hostile_puppet_glove.companions.client_message.player_wins"), true);
                this.playingPlayerUUID = null;
            }
            this.gameAutoStop = this.f_19797_ + 600;
        } else {
            this.setBroomPhase(1);
            TickScheduler.scheduleServer((Level)this.m_9236_(), () -> this.setIsPlaying(true), (int)20);
            TickScheduler.scheduleServer((Level)this.m_9236_(), () -> this.setGloveMove(0), (int)20);
            this.playingPlayerUUID = pPlayer.m_20148_();
            this.gameAutoStop = this.f_19797_ + 600;
            pPlayer.m_5661_((Component)Component.m_237115_((String)"hostile_puppet_glove.companions.client_message.game_start"), true);
        }
        return InteractionResult.SUCCESS;
    }

    public static boolean isEntityInFront(LivingEntity viewer, Entity target, double fov) {
        Vec3 toTarget;
        Vec3 view = viewer.m_20154_().m_82541_();
        double angle = Math.acos(view.m_82526_(toTarget = new Vec3(target.m_20185_(), viewer.m_20186_(), target.m_20189_()).m_82546_(viewer.m_20182_()).m_82541_())) * 57.29577951308232;
        return angle < fov / 2.0;
    }

    private int doesThePlayerWin(int playerMove, int gloveMove) {
        if (playerMove == 0) {
            if (gloveMove == 1) {
                return 0;
            }
            if (gloveMove == 2) {
                return 1;
            }
            if (gloveMove == 3) {
                return 2;
            }
        } else if (playerMove == 1) {
            if (gloveMove == 1) {
                return 2;
            }
            if (gloveMove == 2) {
                return 0;
            }
            if (gloveMove == 3) {
                return 1;
            }
        } else if (playerMove == 2) {
            if (gloveMove == 1) {
                return 1;
            }
            if (gloveMove == 2) {
                return 2;
            }
            if (gloveMove == 3) {
                return 0;
            }
        }
        return -1;
    }

    private boolean isValidItem(ItemStack stack) {
        return stack.m_41720_() == Items.f_42516_ || stack.m_41720_() == Items.f_42594_ || stack.m_41720_() == Items.f_42574_;
    }

    private int getPlayerMoveFromItem(ItemStack stack) {
        if (stack.m_41720_() == Items.f_42594_) {
            return 0;
        }
        if (stack.m_41720_() == Items.f_42516_) {
            return 1;
        }
        if (stack.m_41720_() == Items.f_42574_) {
            return 2;
        }
        return -1;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_PLAYING, (Object)false);
        this.f_19804_.m_135372_(GLOVE_MOVE, (Object)-1);
        this.f_19804_.m_135372_(BROOM_PHASE, (Object)0);
    }

    private void setIsPlaying(boolean playing) {
        this.f_19804_.m_135381_(IS_PLAYING, (Object)playing);
    }

    private boolean isPlaying() {
        return (Boolean)this.f_19804_.m_135370_(IS_PLAYING);
    }

    private void setBroomPhase(int phase) {
        this.f_19804_.m_135381_(BROOM_PHASE, (Object)phase);
    }

    private int getBroomPhase() {
        return (Integer)this.f_19804_.m_135370_(BROOM_PHASE);
    }

    private void setGloveMove(int phase) {
        this.f_19804_.m_135381_(GLOVE_MOVE, (Object)phase);
    }

    private int getGloveMove() {
        return (Integer)this.f_19804_.m_135370_(GLOVE_MOVE);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.isPlaying()) {
            if (this.getGloveMove() == 1) {
                event.setAnimation(this.GAME_ROCK);
            } else if (this.getGloveMove() == 2) {
                event.setAnimation(this.GAME_PAPER);
            } else if (this.getGloveMove() == 3) {
                event.setAnimation(this.GAME_SCISSORS);
            } else if (this.getGloveMove() == 4) {
                event.setAnimation(this.GAME_ATTACK);
            } else if (this.getGloveMove() == 5) {
                event.setAnimation(this.GAME_LOOSE);
            } else if (this.getGloveMove() == 6) {
                event.setAnimation(this.GAME_TAME);
            } else {
                event.setAnimation(this.GAME_IDLE);
            }
        } else if (this.getBroomPhase() == 1) {
            event.setAnimation(this.BROOM_DROP);
        } else if (this.getBroomPhase() == 2) {
            event.setAnimation(this.BROOM_PICKUP);
        } else {
            event.setAnimation(this.BROOM_IDLE);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

