/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.container.SoulMageContainerMenu;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionRandomStrollGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsLookAtPlayerGoal;
import dev.xylonity.companions.common.entity.ai.mage.goal.SoulMageBlackHoleGoal;
import dev.xylonity.companions.common.entity.ai.mage.goal.SoulMageBraceGoal;
import dev.xylonity.companions.common.entity.ai.mage.goal.SoulMageFireMarkGoal;
import dev.xylonity.companions.common.entity.ai.mage.goal.SoulMageHealRingGoal;
import dev.xylonity.companions.common.entity.ai.mage.goal.SoulMageIceShardGoal;
import dev.xylonity.companions.common.entity.ai.mage.goal.SoulMageMagicRayGoal;
import dev.xylonity.companions.common.entity.ai.mage.goal.SoulMageNaginataGoal;
import dev.xylonity.companions.common.entity.ai.mage.goal.SoulMageStoneSpikesGoal;
import dev.xylonity.companions.common.entity.ai.mage.goal.SoulMageTornadoGoal;
import dev.xylonity.companions.common.entity.summon.LivingCandleEntity;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class SoulMageEntity
extends CompanionEntity
implements ContainerListener {
    public SimpleContainer inventory;
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private static final EntityDataAccessor<Integer> SIT_VARIATION = SynchedEntityData.m_135353_(SoulMageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.m_135353_(SoulMageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.m_135353_(SoulMageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<String> ATTACK_ANIMATION_NAME = SynchedEntityData.m_135353_(SoulMageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> CANDLE_COUNT = SynchedEntityData.m_135353_(SoulMageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BOOK_ID = SynchedEntityData.m_135353_(SoulMageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> CURRENT_ATTACK_TYPE = SynchedEntityData.m_135353_(SoulMageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final int MAX_CANDLES_COUNT = 6;
    public List<LivingCandleEntity> candles = new LinkedList<LivingCandleEntity>();
    public static final Map<String, int[]> ATTACK_COLORS = Map.of("MAGIC_RAY", new int[]{173, 216, 230}, "BLACK_HOLE", new int[]{128, 0, 128}, "STONE_SPIKES", new int[]{139, 69, 19}, "HEAL_RING", new int[]{110, 252, 85}, "ICE_SHARD", new int[]{134, 236, 255}, "FIRE_MARK", new int[]{225, 45, 45}, "TORNADO", new int[]{242, 242, 242}, "NONE", new int[]{169, 134, 60});

    public SoulMageEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.createInventory();
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    protected void createInventory() {
        SimpleContainer oldInv = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (oldInv != null) {
            int min = Math.min(oldInv.m_6643_(), this.inventory.m_6643_());
            for (int i = 0; i < min; ++i) {
                ItemStack stack = oldInv.m_8020_(i);
                this.inventory.m_6836_(i, stack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
    }

    protected int getInventorySize() {
        return 3;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new SoulMageMagicRayGoal(this, 70, 160));
        this.f_21345_.m_25352_(3, (Goal)new SoulMageBlackHoleGoal(this, 70, 160));
        this.f_21345_.m_25352_(3, (Goal)new SoulMageStoneSpikesGoal(this, 70, 160));
        this.f_21345_.m_25352_(3, (Goal)new SoulMageHealRingGoal(this, 70, 160));
        this.f_21345_.m_25352_(3, (Goal)new SoulMageIceShardGoal(this, 70, 160));
        this.f_21345_.m_25352_(3, (Goal)new SoulMageFireMarkGoal(this, 70, 160));
        this.f_21345_.m_25352_(3, (Goal)new SoulMageTornadoGoal(this, 70, 160));
        this.f_21345_.m_25352_(3, (Goal)new SoulMageBraceGoal(this, 70, 160));
        this.f_21345_.m_25352_(3, (Goal)new SoulMageNaginataGoal(this, 70, 160));
        this.f_21345_.m_25352_(4, (Goal)new CompanionFollowOwnerGoal(this, 0.6, 6.0f, 2.0f, false));
        this.f_21345_.m_25352_(4, (Goal)new CompanionRandomStrollGoal(this, 0.43));
        this.f_21345_.m_25352_(6, (Goal)new CompanionsLookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new CompanionsHurtTargetGoal(this));
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pAmount > this.m_21223_() && !this.candles.isEmpty()) {
            LivingCandleEntity candle = this.candles.remove(0);
            this.setCandleCount(this.getCandleCount() - 1);
            candle.doKill();
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public String getCurrentAttackType() {
        return (String)this.f_19804_.m_135370_(CURRENT_ATTACK_TYPE);
    }

    public void setCurrentAttackType(String attackType) {
        this.f_19804_.m_135381_(CURRENT_ATTACK_TYPE, (Object)attackType);
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, CompanionsConfig.SOUL_MAGE_MAX_LIFE).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    public void setCandleCount(int candleCount) {
        this.f_19804_.m_135381_(CANDLE_COUNT, (Object)candleCount);
    }

    public int getCandleCount() {
        return (Integer)this.f_19804_.m_135370_(CANDLE_COUNT);
    }

    public String getAttackAnimationName() {
        return (String)this.f_19804_.m_135370_(ATTACK_ANIMATION_NAME);
    }

    public void setAttackAnimationName(String s) {
        this.f_19804_.m_135381_(ATTACK_ANIMATION_NAME, (Object)s);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(IS_ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(IS_ATTACKING, (Object)attacking);
    }

    public int getBookId() {
        return (Integer)this.f_19804_.m_135370_(BOOK_ID);
    }

    public void setBookId(int id) {
        this.f_19804_.m_135381_(BOOK_ID, (Object)id);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SIT_VARIATION, (Object)0);
        this.f_19804_.m_135372_(IS_ATTACKING, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_FLAGS, (Object)0);
        this.f_19804_.m_135372_(ATTACK_ANIMATION_NAME, (Object)"");
        this.f_19804_.m_135372_(CANDLE_COUNT, (Object)0);
        this.f_19804_.m_135372_(BOOK_ID, (Object)-1);
        this.f_19804_.m_135372_(CURRENT_ATTACK_TYPE, (Object)"NONE");
    }

    @Nullable
    public LivingEntity m_269323_() {
        return super.m_269323_();
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && this.m_269323_() == player && player.m_6144_() && hand == InteractionHand.MAIN_HAND) {
            if (!this.m_9236_().f_46443_) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                    @NotNull
                    public Component m_5446_() {
                        return SoulMageEntity.this.m_7755_();
                    }

                    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory playerInv, @NotNull Player player) {
                        return new SoulMageContainerMenu(id, playerInv, SoulMageEntity.this);
                    }
                }, buf -> buf.writeInt(this.m_19879_()));
                this.m_5496_(SoundEvents.f_11678_, 0.5f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.handleDefaultMainActionAndHeal(player, hand)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.inventory.m_7797_(pCompound.m_128437_("Inventory", 10));
        if (pCompound.m_128441_("BookEntityId")) {
            this.f_19804_.m_135381_(BOOK_ID, (Object)pCompound.m_128451_("BookEntityId"));
        }
        this.setBookId(pCompound.m_128451_("BookId"));
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128365_("Inventory", (Tag)this.inventory.m_7927_());
        pCompound.m_128405_("BookId", this.getBookId());
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return CompanionsSounds.MAGE_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return CompanionsSounds.MAGE_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return CompanionsSounds.MAGE_HURT.get();
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.m_5496_(CompanionsSounds.MAGE_STEP.get(), 0.2f, 1.0f);
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 1;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.SOUL_MAGE_KEEP_CHUNK_LOADED;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 1, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackcontroller", 1, this::attackPredicate)});
    }

    private <T extends GeoAnimatable> PlayState attackPredicate(AnimationState<T> event) {
        if (this.isAttacking() && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.setAnimation(RawAnimation.begin().thenPlay(this.getAttackAnimationName()));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getMainAction() == 0) {
            event.setAnimation(this.SIT);
        } else if (event.isMoving()) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    public void m_8107_() {
        this.setNoMovement(this.isAttacking());
        super.m_8107_();
    }

    public void m_5757_(@NotNull Container container) {
        this.updateContainerEquipment();
    }

    protected void updateContainerEquipment() {
        if (!this.m_9236_().f_46443_) {
            this.setFlag(4, !this.inventory.m_8020_(0).m_41619_());
        }
    }

    protected void setFlag(int $$0, boolean $$1) {
        byte $$2 = (Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS);
        if ($$1) {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)($$2 | $$0)));
        } else {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)($$2 & ~$$0)));
        }
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemStack = this.inventory.m_8020_(i);
                if (itemStack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemStack)) continue;
                this.m_19983_(itemStack);
            }
        }
    }
}

