/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ShadeEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.entity.ai.shade.sword.ShadeSwordMoveControl;
import dev.xylonity.companions.common.entity.ai.shade.sword.goal.ShadeSwordFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.shade.sword.goal.ShadeSwordFollowTargetGoal;
import dev.xylonity.companions.common.entity.ai.shade.sword.goal.ShadeSwordGroundAttackGoal;
import dev.xylonity.companions.common.entity.ai.shade.sword.goal.ShadeSwordMeleeAttackGoal;
import dev.xylonity.companions.common.entity.ai.shade.sword.goal.ShadeSwordSpinAttackGoal;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.api.scheduler.TickScheduler;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ShadeSwordEntity
extends ShadeEntity {
    private final RawAnimation SPAWN = RawAnimation.begin().thenPlay("spawn");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation ATTACK = RawAnimation.begin().thenPlay("attack");
    private final RawAnimation ATTACK2 = RawAnimation.begin().thenPlay("attack2");
    private final RawAnimation GROUND_ATTACK = RawAnimation.begin().thenPlay("nail_to_ground");
    private final RawAnimation SPIN_ATTACK = RawAnimation.begin().thenPlay("spin");
    private static final int ANIMATION_SPAWN_MAX_TICKS = 72;
    private boolean hasSpawned;

    public ShadeSwordEntity(EntityType<? extends CompanionEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19794_ = true;
        this.hasSpawned = false;
        this.m_20242_(true);
        this.f_19811_ = true;
        this.f_21342_ = new ShadeSwordMoveControl(this);
    }

    @Override
    public int getMaxLifetime() {
        return CompanionsConfig.SHADOW_SWORD_LIFETIME;
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new ShadeSwordMeleeAttackGoal(this, 20, 60));
        this.f_21345_.m_25352_(1, (Goal)new ShadeSwordSpinAttackGoal(this, 70, 200));
        this.f_21345_.m_25352_(1, (Goal)new ShadeSwordGroundAttackGoal(this, 120, 300));
        this.f_21345_.m_25352_(2, (Goal)new ShadeSwordFollowTargetGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new ShadeSwordFollowOwnerGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new CompanionsHurtTargetGoal(this));
    }

    protected void m_6677_(@NotNull DamageSource pSource) {
        this.m_216990_(CompanionsSounds.SHADE_HURT.get());
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return CompanionsSounds.SHADE_IDLE.get();
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, CompanionsConfig.SHADOW_SWORD_MAX_LIFE).m_22268_(Attributes.f_22281_, CompanionsConfig.SHADOW_SWORD_DAMAGE).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.hasSpawned) {
            TickScheduler.scheduleServer((Level)this.m_9236_(), () -> this.setIsSpawning(false), (int)72);
            TickScheduler.scheduleServer((Level)this.m_9236_(), () -> this.m_6842_(false), (int)5);
            this.hasSpawned = true;
        }
        if (this.f_19797_ % 6 == 0 && !this.isSpawning()) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
            double dy = (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
            double dz = (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.m_8767_((ParticleOptions)CompanionsParticles.SHADE_TRAIL.get(), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20189_(), 1, dx, dy, dz, 0.1);
            }
        }
        this.setLifetime(this.getLifetime() - 1);
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 2;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return false;
    }

    @Nullable
    public LivingEntity m_269323_() {
        return super.m_269323_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.isSpawning()) {
            event.setAnimation(this.SPAWN);
        } else if (this.getAttackType() == 1) {
            event.setAnimation(this.ATTACK);
        } else if (this.getAttackType() == 2) {
            event.setAnimation(this.ATTACK2);
        } else if (this.getAttackType() == 3) {
            event.setAnimation(this.GROUND_ATTACK);
        } else if (this.getAttackType() == 4) {
            event.setAnimation(this.SPIN_ATTACK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    public void m_8107_() {
        this.setNoMovement(this.getAttackType() != 0);
        super.m_8107_();
    }
}

