/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionRandomStrollGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsLookAtPlayerGoal;
import dev.xylonity.companions.common.entity.ai.mankh.goal.MankhChestShotAttackGoal;
import dev.xylonity.companions.common.entity.ai.mankh.goal.MankhRingAttackGoal;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class MankhEntity
extends CompanionEntity {
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation SIT2 = RawAnimation.begin().thenPlay("sit2");
    private final RawAnimation CHEST_SHOT = RawAnimation.begin().thenPlay("chest_shot");
    private final RawAnimation RING_ATTACK = RawAnimation.begin().thenPlay("ring_attack");
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.m_135353_(MankhEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public MankhEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19811_ = true;
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 2;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.MANKH_KEEP_CHUNK_LOADED;
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22276_, CompanionsConfig.MANKH_MAX_LIFE).m_22268_(Attributes.f_22281_, CompanionsConfig.MANKH_DAMAGE).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MankhChestShotAttackGoal(this, 10, 30));
        this.f_21345_.m_25352_(1, (Goal)new MankhRingAttackGoal(this, 10, 30));
        this.f_21345_.m_25352_(3, (Goal)new CompanionFollowOwnerGoal(this, 0.6, 6.0f, 2.0f, false));
        this.f_21345_.m_25352_(3, (Goal)new CompanionRandomStrollGoal(this, 0.43));
        this.f_21345_.m_25352_(6, (Goal)new CompanionsLookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new CompanionsHurtTargetGoal(this));
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return CompanionsSounds.MANKH_DEATH.get();
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.m_216990_(CompanionsSounds.MANKH_STEP.get());
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleDefaultMainActionAndHeal(player, hand)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_TYPE, (Object)0);
    }

    public int getAttackType() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TYPE);
    }

    public void setAttackType(int attackType) {
        this.f_19804_.m_135381_(ATTACK_TYPE, (Object)attackType);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getMainAction() == 0) {
            event.getController().setAnimation(this.getSitVariation() == 0 ? this.SIT : this.SIT2);
        } else if (this.getAttackType() == 1) {
            event.getController().setAnimation(this.CHEST_SHOT);
        } else if (this.getAttackType() == 2) {
            event.getController().setAnimation(this.RING_ATTACK);
        } else if (event.isMoving()) {
            event.getController().setAnimation(this.WALK);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

