/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.croissant.CroissantDragonAttackGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionRandomStrollGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.api.scheduler.TickScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class CroissantDragonEntity
extends CompanionEntity {
    public SimpleContainer inventory;
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation SIT2 = RawAnimation.begin().thenPlay("sit2");
    private final RawAnimation ATTACK = RawAnimation.begin().thenPlay("attack");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation EATEN = RawAnimation.begin().thenPlay("eaten");
    private final RawAnimation FLY = RawAnimation.begin().thenPlay("fly");
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.m_135353_(CroissantDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> ARMOR_NAME = SynchedEntityData.m_135353_(CroissantDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> EATEN_AMOUNT = SynchedEntityData.m_135353_(CroissantDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_BEEN_EATEN = SynchedEntityData.m_135353_(CroissantDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> MILK_AMOUNT = SynchedEntityData.m_135353_(CroissantDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> VIEW_VEC_X = SynchedEntityData.m_135353_(CroissantDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> VIEW_VEC_Y = SynchedEntityData.m_135353_(CroissantDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> VIEW_VEC_Z = SynchedEntityData.m_135353_(CroissantDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final int EATEN_DELAY = 10;
    private int nextEatenRecover = 0;

    public CroissantDragonEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new CroissantDragonAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new CompanionFollowOwnerGoal(this, 0.6, 6.0f, 2.0f, false));
        this.f_21345_.m_25352_(3, (Goal)new CompanionRandomStrollGoal(this, 0.43));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new CompanionsHurtTargetGoal(this));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isAttacking()) {
            Companions.PROXY.updateCreamParticle(this.getStoredViewVector());
        }
        if (!this.m_9236_().f_46443_) {
            if (this.getEatenAmount() > 0 && this.f_19797_ >= this.nextEatenRecover) {
                this.setEatenAmount(this.getEatenAmount() - 1);
                this.setHasBeenEaten(true);
                TickScheduler.scheduleServer((Level)this.m_9236_(), () -> this.setHasBeenEaten(false), (int)10);
                this.nextEatenRecover = this.f_19797_ + this.m_9236_().m_213780_().m_188503_(201) + 100;
            }
            if (this.m_21824_()) {
                this.setMilkAmount(3);
            }
        }
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, CompanionsConfig.CROISSANT_DRAGON_MAX_LIFE).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    public void setEatenAmount(int eatenAmount) {
        this.f_19804_.m_135381_(EATEN_AMOUNT, (Object)eatenAmount);
    }

    public int getEatenAmount() {
        return (Integer)this.f_19804_.m_135370_(EATEN_AMOUNT);
    }

    public void setArmorName(String name) {
        this.f_19804_.m_135381_(ARMOR_NAME, (Object)name);
    }

    public String getArmorName() {
        return (String)this.f_19804_.m_135370_(ARMOR_NAME);
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        if (this.getEatenAmount() > 0) {
            this.m_216990_(CompanionsSounds.CROISSANT_DRAGON_CREAM_STEPS.get());
        }
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return CompanionsSounds.CROISSANT_DRAGON_CREAM_DEATH.get();
    }

    public void m_8032_() {
        this.m_5496_(CompanionsSounds.CROISSANT_DRAGON_CREAM_IDLE.get(), 0.4f, 1.0f);
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return CompanionsSounds.CROISSANT_DRAGON_CREAM_HURT.get();
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(IS_ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(IS_ATTACKING, (Object)attacking);
    }

    public boolean hasBeenEaten() {
        return (Boolean)this.f_19804_.m_135370_(HAS_BEEN_EATEN);
    }

    public void setHasBeenEaten(boolean eaten) {
        this.f_19804_.m_135381_(HAS_BEEN_EATEN, (Object)eaten);
    }

    public int getMilkAmount() {
        return (Integer)this.f_19804_.m_135370_(MILK_AMOUNT);
    }

    public void setMilkAmount(int milk) {
        this.f_19804_.m_135381_(MILK_AMOUNT, (Object)milk);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ATTACKING, (Object)false);
        this.f_19804_.m_135372_(ARMOR_NAME, (Object)"default");
        this.f_19804_.m_135372_(EATEN_AMOUNT, (Object)0);
        this.f_19804_.m_135372_(HAS_BEEN_EATEN, (Object)false);
        this.f_19804_.m_135372_(MILK_AMOUNT, (Object)0);
        this.f_19804_.m_135372_(VIEW_VEC_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(VIEW_VEC_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(VIEW_VEC_Z, (Object)Float.valueOf(0.0f));
    }

    public void setStoredViewVector(Vec3 vec) {
        this.f_19804_.m_135381_(VIEW_VEC_X, (Object)Float.valueOf((float)vec.f_82479_));
        this.f_19804_.m_135381_(VIEW_VEC_Y, (Object)Float.valueOf((float)vec.f_82480_));
        this.f_19804_.m_135381_(VIEW_VEC_Z, (Object)Float.valueOf((float)vec.f_82481_));
    }

    public Vec3 getStoredViewVector() {
        return new Vec3((double)((Float)this.f_19804_.m_135370_(VIEW_VEC_X)).floatValue(), (double)((Float)this.f_19804_.m_135370_(VIEW_VEC_Y)).floatValue(), (double)((Float)this.f_19804_.m_135370_(VIEW_VEC_Z)).floatValue());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("MilkAmount")) {
            this.setMilkAmount(pCompound.m_128451_("MilkAmount"));
        }
        if (pCompound.m_128441_("EatenAmount")) {
            this.setEatenAmount(pCompound.m_128451_("EatenAmount"));
        }
        if (pCompound.m_128441_("ArmorName")) {
            this.setArmorName(pCompound.m_128461_("ArmorName"));
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("MilkAmount", this.getMilkAmount());
        pCompound.m_128405_("EatenAmount", this.getEatenAmount());
        pCompound.m_128359_("ArmorName", this.getArmorName());
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 2;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.CROISSANT_DRAGON_KEEP_CHUNK_LOADED;
    }

    @Nullable
    public LivingEntity m_269323_() {
        return super.m_269323_();
    }

    @NotNull
    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.m_21824_() && this.m_269323_() == player && player.m_6144_() && !this.m_9236_().f_46443_ && hand == InteractionHand.MAIN_HAND && this.getEatenAmount() < 2 && !this.hasBeenEaten()) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            this.m_5496_(SoundEvents.f_12639_, 0.5f, 1.0f);
            this.setEatenAmount(this.getEatenAmount() + 1);
            this.setHasBeenEaten(true);
            TickScheduler.scheduleServer((Level)this.m_9236_(), () -> this.setHasBeenEaten(false), (int)10);
            this.nextEatenRecover = this.f_19797_ + this.m_9236_().m_213780_().m_188503_(201) + 100;
            switch (this.getArmorName()) {
                case "chocolate": {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 200, 0));
                    break;
                }
                case "strawberry": {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 180, 1));
                    break;
                }
                case "vanilla": {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 600, 0));
                    break;
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.m_21824_() && itemstack.m_41720_() == Items.f_42455_ && this.getMilkAmount() < 3) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
                if (itemstack.m_41619_()) {
                    player.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42446_));
                } else if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42446_))) {
                    player.m_36176_(new ItemStack((ItemLike)Items.f_42446_), false);
                }
            }
            if (!ForgeEventFactory.onAnimalTame((Animal)this, (Player)player) && this.getMilkAmount() == 2 && !this.m_9236_().f_46443_) {
                this.tameInteraction(player);
            }
            this.setMilkAmount(this.getMilkAmount() + 1);
            player.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11970_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (!this.m_21824_()) {
            player.m_5661_((Component)Component.m_237115_((String)"croissant_dragon.companions.client_message.requires_milk"), true);
            player.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12507_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.PASS;
        }
        if (this.m_21824_() && !this.m_9236_().f_46443_ && hand == InteractionHand.MAIN_HAND && this.m_269323_() == player && this.getArmorName().equals("default")) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41720_() == CompanionsItems.CROISSANT_DRAGON_ARMOR_STRAWBERRY.get()) {
                this.setArmorName("strawberry");
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41720_() == CompanionsItems.CROISSANT_DRAGON_ARMOR_VANILLA.get()) {
                this.setArmorName("vanilla");
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41720_() == CompanionsItems.CROISSANT_DRAGON_ARMOR_CHOCOLATE.get()) {
                this.setArmorName("chocolate");
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            this.m_5496_(SoundEvents.f_12639_, 0.5f, 1.0f);
        }
        if (this.handleDefaultMainActionAndHeal(player, hand)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "eatencontroller", 2, this::eatenPredicate)});
    }

    private <T extends GeoAnimatable> PlayState eatenPredicate(AnimationState<T> event) {
        if (this.hasBeenEaten() && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.setAnimation(this.EATEN);
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getMainAction() == 0) {
            event.getController().setAnimation(this.getSitVariation() == 0 ? this.SIT : this.SIT2);
        } else if (this.isAttacking()) {
            event.getController().setAnimation(this.ATTACK);
        } else if (event.isMoving()) {
            event.getController().setAnimation(this.getEatenAmount() == 0 ? this.FLY : this.WALK);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    public void m_8107_() {
        this.setNoMovement(this.isAttacking());
        super.m_8107_();
    }
}

