/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.common.entity.HostileEntity;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtils;

public class FrogBonanzaBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final RawAnimation COIN = RawAnimation.begin().thenPlay("coin");
    public static final RawAnimation LEVER = RawAnimation.begin().thenPlay("lever");
    private static final int DELAY_BETWEEN_WHEELS = 4;
    private static final int GAME_TICKS = 100;
    private static final float EXTRA_SPINS = 720.0f;
    private final float[] rotation = new float[3];
    private final float[] startRot = new float[3];
    private final float[] totalRot = new float[3];
    private final int[] faceDeg = new int[3];
    private int spinStartTick = -1;
    private int tickCount = 0;
    private int spinsRemaining = 0;
    private static final String TAG_ROT = "Rot";
    private static final String TAG_FACE = "Face";
    private static final String TAG_START = "Start";
    private static final String TAG_TOTAL = "Total";

    public FrogBonanzaBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CompanionsBlockEntities.FROG_BONANZA.get(), pos, state);
    }

    public void startSpinning(int[] finalFacesDeg) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            this.faceDeg[i] = finalFacesDeg[i] % 360;
            this.startRot[i] = this.rotation[i];
            float delta = (float)this.faceDeg[i] - Util.normalizeDeg(this.startRot[i]);
            if (delta < 0.0f) {
                delta += 360.0f;
            }
            this.totalRot[i] = delta + 720.0f;
        }
        this.spinStartTick = this.tickCount;
        this.sync();
    }

    public void startGame() {
        this.startSpinning(new int[]{new Random().nextInt(4) * 90, new Random().nextInt(4) * 90, new Random().nextInt(4) * 90});
    }

    public float getWheelRotation(int idx) {
        return this.rotation[idx];
    }

    public static <T extends BlockEntity> void tick(Level lvl, BlockPos pos, BlockState st, T be) {
        if (!(be instanceof FrogBonanzaBlockEntity)) {
            return;
        }
        FrogBonanzaBlockEntity b = (FrogBonanzaBlockEntity)be;
        if (b.spinStartTick < 0) {
            return;
        }
        boolean hasFinished = true;
        for (int i = 0; i < 3; ++i) {
            int local = b.tickCount - (b.spinStartTick + i * 4);
            if (local < 0) {
                hasFinished = false;
                continue;
            }
            if (local >= 100) {
                b.rotation[i] = b.faceDeg[i];
                continue;
            }
            hasFinished = false;
            b.rotation[i] = Util.normalizeDeg(b.startRot[i] + b.totalRot[i] * (1.0f - (float)Math.pow(1.0f - (float)local / 100.0f, 3.0)));
        }
        if (hasFinished) {
            b.spinStartTick = -1;
            b.getFroggyReward();
            b.sync();
        }
        ++b.tickCount;
    }

    private void getFroggyReward() {
        ConcurrentHashMap<Integer, Integer> counts = new ConcurrentHashMap<Integer, Integer>();
        for (int f : this.faceDeg) {
            counts.put(f, counts.getOrDefault(f, 0) + 1);
        }
        if (counts.size() == 1) {
            switch (this.faceDeg[0]) {
                case 0: {
                    this.tripleCreeper();
                    break;
                }
                case 90: {
                    this.tripleCoin();
                    break;
                }
                case 180: {
                    this.tripleTeddy();
                    break;
                }
                case 270: {
                    this.tripleSkull();
                }
            }
            return;
        }
        Object object = counts.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            if ((Integer)entry.getValue() != 2) continue;
            switch ((Integer)entry.getKey()) {
                case 0: {
                    this.doubleCreeper();
                    break;
                }
                case 90: {
                    this.doubleCoin();
                    break;
                }
                case 180: {
                    this.doubleTeddy();
                    break;
                }
                case 270: {
                    this.doubleSkull();
                }
            }
            return;
        }
    }

    private static List<TeddyDrop> parseBonanzaTeddyDrops(String config) {
        ArrayList<TeddyDrop> list = new ArrayList<TeddyDrop>();
        if (config == null || config.isBlank()) {
            return list;
        }
        for (String part : config.split(";")) {
            int max;
            int min;
            float chance;
            String[] entry = part.trim().split(",");
            if (entry.length != 3) continue;
            try {
                chance = Float.parseFloat(entry[1].trim());
            }
            catch (NumberFormatException ignore) {
                continue;
            }
            String count = entry[2].trim();
            if (count.contains("-")) {
                String[] range = count.split("-");
                try {
                    min = Integer.parseInt(range[0].trim());
                    max = Integer.parseInt(range[1].trim());
                }
                catch (NumberFormatException ignore) {
                    min = 1;
                    max = 1;
                }
            } else {
                try {
                    min = Integer.parseInt(count);
                    max = Integer.parseInt(count);
                }
                catch (NumberFormatException ignore) {
                    min = 1;
                    max = 1;
                }
            }
            list.add(new TeddyDrop(entry[0].trim(), chance, min, max));
        }
        return list;
    }

    private static List<SkullDropEntities> parseEntitySpawns(String config) {
        ArrayList<SkullDropEntities> list = new ArrayList<SkullDropEntities>();
        if (config == null || config.isBlank()) {
            return list;
        }
        for (String part : config.split(";")) {
            int amount;
            String[] entry = part.trim().split(",");
            if (entry.length != 2) continue;
            String id = entry[0].trim();
            try {
                amount = Integer.parseInt(entry[1].trim());
            }
            catch (NumberFormatException ignore) {
                continue;
            }
            list.add(new SkullDropEntities(id, amount));
        }
        return list;
    }

    private void doubleCreeper() {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            BlockPos center = this.f_58858_.m_7494_();
            for (int i = 0; i < 2 + new Random().nextInt(3); ++i) {
                BonanzaTnt tnt = new BonanzaTnt((Level)server, (double)center.m_123341_() + 0.5, center.m_123342_(), (double)center.m_123343_() + 0.5, null);
                double angle = this.m_58904_().f_46441_.m_188500_() * Math.PI * 2.0;
                double speed = 0.15 + this.m_58904_().f_46441_.m_188500_() * 0.6;
                tnt.m_20334_(Math.cos(angle) * speed, 0.5 + this.m_58904_().f_46441_.m_188500_() * 0.3, Math.sin(angle) * speed);
                tnt.m_32085_(40);
                server.m_7967_((Entity)tnt);
            }
            this.m_58904_().m_247517_(null, this.m_58899_(), CompanionsSounds.POP.get(), SoundSource.BLOCKS);
        }
    }

    private void doubleCoin() {
        if (this.m_58904_() != null) {
            FrogBonanzaBlockEntity.popResource(this.m_58904_(), this.m_58899_(), new ItemStack((ItemLike)CompanionsBlocks.COPPER_COIN.get(), new Random().nextInt(2, 10)));
            FrogBonanzaBlockEntity.popResource(this.m_58904_(), this.m_58899_(), new ItemStack((ItemLike)CompanionsBlocks.NETHER_COIN.get(), new Random().nextInt(1, 4)));
            FrogBonanzaBlockEntity.popResource(this.m_58904_(), this.m_58899_(), new ItemStack((ItemLike)CompanionsBlocks.END_COIN.get()));
            this.m_58904_().m_247517_(null, this.m_58899_(), CompanionsSounds.POP.get(), SoundSource.BLOCKS);
        }
    }

    private void doubleTeddy() {
        if (this.m_58904_() != null) {
            FrogBonanzaBlockEntity.parseBonanzaTeddyDrops(CompanionsConfig.BONANZA_2_TEDDY_HEADS_DROPS).forEach(drop -> {
                Item item;
                if (this.m_58904_().m_213780_().m_188501_() < drop.chance && (item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(drop.id()))) != null) {
                    FrogBonanzaBlockEntity.popResource(this.m_58904_(), this.m_58899_(), new ItemStack((ItemLike)item, drop.min == drop.max ? drop.min : this.m_58904_().m_213780_().m_216339_(drop.min, drop.max + 1)));
                }
            });
            this.m_58904_().m_247517_(null, this.m_58899_(), CompanionsSounds.POP.get(), SoundSource.BLOCKS);
        }
    }

    private void doubleSkull() {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 center = Vec3.m_82512_((Vec3i)this.m_58899_());
            Player player = serverLevel.m_45924_(center.f_82479_, center.f_82480_, center.f_82481_, 25.0, false);
            if (player != null) {
                FallingBlockEntity anvil = new FallingBlockEntity((Level)serverLevel, player.m_20185_(), player.m_20186_() + 20.0, player.m_20189_(), Blocks.f_50322_.m_49966_());
                anvil.f_31942_ = 1;
                anvil.m_272001_();
                anvil.m_149656_(2.0f, 40);
                serverLevel.m_7967_((Entity)anvil);
            }
            this.m_58904_().m_247517_(null, this.m_58899_(), CompanionsSounds.POP.get(), SoundSource.BLOCKS);
        }
    }

    private void tripleCreeper() {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            BlockPos center = this.f_58858_.m_7494_();
            for (int i = 0; i < 3; ++i) {
                double angle = new Random().nextDouble() * Math.PI * 2.0;
                double dist = new Random().nextDouble() * 4.0;
                double x = (double)center.m_123341_() + 0.5 + Math.cos(angle) * dist;
                double y = center.m_123342_();
                double z = (double)center.m_123343_() + 0.5 + Math.sin(angle) * dist;
                Creeper creeper = (Creeper)EntityType.f_20558_.m_20615_((Level)server);
                if (creeper == null) continue;
                creeper.m_7678_(x, y, z, new Random().nextFloat() * 360.0f, 0.0f);
                LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)server);
                if (bolt != null) {
                    bolt.m_6027_(x, y, z);
                    server.m_7967_((Entity)bolt);
                    creeper.m_8038_(server, bolt);
                }
                server.m_7967_((Entity)creeper);
            }
            this.m_58904_().m_247517_(null, this.m_58899_(), CompanionsSounds.POP.get(), SoundSource.BLOCKS);
        }
    }

    private void tripleCoin() {
        if (this.m_58904_() != null) {
            RandomSource rand = this.m_58904_().m_213780_();
            FrogBonanzaBlockEntity.popResource(this.m_58904_(), this.m_58899_(), new ItemStack((ItemLike)CompanionsBlocks.COPPER_COIN.get(), rand.m_216339_(1, 20)));
            if (rand.m_188501_() < 0.75f) {
                FrogBonanzaBlockEntity.popResource(this.m_58904_(), this.m_58899_(), new ItemStack((ItemLike)CompanionsBlocks.NETHER_COIN.get(), rand.m_216339_(1, 5)));
            }
            if (rand.m_188501_() < 0.45f) {
                FrogBonanzaBlockEntity.popResource(this.m_58904_(), this.m_58899_(), new ItemStack((ItemLike)CompanionsBlocks.END_COIN.get(), 1));
            }
            this.m_58904_().m_247517_(null, this.m_58899_(), CompanionsSounds.POP.get(), SoundSource.BLOCKS);
        }
    }

    private void tripleTeddy() {
        if (this.m_58904_() != null && this.m_58904_() != null) {
            FrogBonanzaBlockEntity.parseBonanzaTeddyDrops(CompanionsConfig.BONANZA_3_TEDDY_HEADS_DROPS).forEach(drop -> {
                Item item;
                if (this.m_58904_().m_213780_().m_188501_() < drop.chance && (item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(drop.id()))) != null) {
                    FrogBonanzaBlockEntity.popResource(this.m_58904_(), this.m_58899_(), new ItemStack((ItemLike)item, drop.min == drop.max ? drop.min : this.m_58904_().m_213780_().m_216339_(drop.min, drop.max + 1)));
                }
            });
            this.m_58904_().m_247517_(null, this.m_58899_(), CompanionsSounds.POP.get(), SoundSource.BLOCKS);
        }
    }

    private void tripleSkull() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        BlockPos center = this.f_58858_.m_7494_();
        Player player = server.m_45924_((double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_(), 15.0, false);
        if (player == null) {
            return;
        }
        for (SkullDropEntities config : FrogBonanzaBlockEntity.parseEntitySpawns(CompanionsConfig.BONANZA_3_SKULL_DROP_ENTITIES)) {
            EntityType raw = (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(config.id()));
            if (raw == null) continue;
            EntityType type = raw;
            for (int i = 0; i < config.amount; ++i) {
                if (type == EntityType.f_217015_) {
                    SpawnUtil.m_216403_((EntityType)type, (MobSpawnType)MobSpawnType.TRIGGERED, (ServerLevel)server, (BlockPos)center, (int)20, (int)5, (int)6, (SpawnUtil.Strategy)SpawnUtil.Strategy.f_216413_).ifPresent(e -> {
                        e.m_7678_(e.m_20185_(), e.m_20186_(), e.m_20189_(), player.m_146908_(), 0.0f);
                        e.m_6710_((LivingEntity)player);
                        e.m_6274_().m_21879_(MemoryModuleType.f_26334_, (Object)player.m_20148_());
                    });
                    continue;
                }
                LivingEntity e2 = (LivingEntity)type.m_262496_(server, new BlockPos(center.m_123341_() - 3 + server.f_46441_.m_188503_(4), center.m_123342_() - 1, center.m_123343_() - 3 + server.f_46441_.m_188503_(4)), MobSpawnType.MOB_SUMMONED);
                if (e2 == null) continue;
                e2.m_7678_(e2.m_20185_(), e2.m_20186_(), e2.m_20189_(), player.m_146908_(), 0.0f);
                if (e2 instanceof HostileEntity) {
                    HostileEntity hostile = (HostileEntity)e2;
                    hostile.m_6710_((LivingEntity)player);
                }
                server.m_7967_((Entity)e2);
            }
        }
        this.f_58857_.m_5594_(null, center, CompanionsSounds.POP.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static void popResource(Level pLevel, BlockPos pPos, ItemStack pStack) {
        double d0 = EntityType.f_20461_.m_20679_() / 2.0f;
        double d1 = (double)pPos.m_123341_() + 0.5;
        double d2 = (double)pPos.m_123342_() + 1.5 + Mth.m_216263_((RandomSource)pLevel.f_46441_, (double)-0.25, (double)0.25) - d0;
        double d3 = (double)pPos.m_123343_() + 0.5;
        FrogBonanzaBlockEntity.popResource(pLevel, () -> new ItemEntity(pLevel, d1, d2, d3, pStack, -0.25 + Math.random() * 0.25, -0.35 + Math.random() * (double)0.35f, -0.25 + Math.random() * 0.25), pStack);
    }

    private static void popResource(Level pLevel, Supplier<ItemEntity> pItemEntitySupplier, ItemStack pStack) {
        if (!pLevel.f_46443_ && !pStack.m_41619_()) {
            ItemEntity itementity = pItemEntitySupplier.get();
            itementity.m_32060_();
            pLevel.m_7967_((Entity)itementity);
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("SpinStart", this.spinStartTick);
        tag.m_128405_("TickCount", this.tickCount);
        tag.m_128365_(TAG_ROT, (Tag)Util.floatsToList(this.rotation));
        tag.m_128365_(TAG_START, (Tag)Util.floatsToList(this.startRot));
        tag.m_128365_(TAG_TOTAL, (Tag)Util.floatsToList(this.totalRot));
        tag.m_128365_(TAG_FACE, (Tag)Util.intsToList(this.faceDeg));
        tag.m_128405_("SpinsRemaining", this.spinsRemaining);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.spinStartTick = tag.m_128451_("SpinStart");
        this.tickCount = tag.m_128451_("TickCount");
        Util.listToFloats(tag.m_128437_(TAG_ROT, 5), this.rotation);
        Util.listToFloats(tag.m_128437_(TAG_START, 5), this.startRot);
        Util.listToFloats(tag.m_128437_(TAG_TOTAL, 5), this.totalRot);
        Util.listToInts(tag.m_128437_(TAG_FACE, 3), this.faceDeg);
        this.spinsRemaining = tag.m_128451_("SpinsRemaining");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    private void sync() {
        if (!(this.f_58857_ instanceof ServerLevel)) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.f_58857_ == null) {
            return InteractionResult.PASS;
        }
        if (this.f_58857_.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (this.spinStartTick >= 0) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (this.spinsRemaining <= 0) {
            int tries = FrogBonanzaBlockEntity.getSpinsForCurrencyItem(item);
            if (tries <= 0) {
                return InteractionResult.PASS;
            }
            this.spinsRemaining = tries;
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.triggerAnim("coin_controller", "coin");
            this.sync();
            this.f_58857_.m_5594_(null, this.m_58899_(), CompanionsSounds.COIN_CLATTER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        --this.spinsRemaining;
        this.triggerAnim("lever_controller", "lever");
        this.startGame();
        this.sync();
        this.f_58857_.m_5594_(null, this.m_58899_(), CompanionsSounds.BONANZA.get(), SoundSource.BLOCKS, 0.35f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    private static Map<Item, Integer> parseBonanzaCurrencies(String configEntry) {
        ConcurrentHashMap<Item, Integer> map = new ConcurrentHashMap<Item, Integer>();
        if (configEntry == null || configEntry.isBlank()) {
            return map;
        }
        for (String part : configEntry.split(";")) {
            int tries;
            ResourceLocation id;
            String[] entry = part.trim().split(",");
            if (entry.length != 2) continue;
            String idString = entry[0].trim();
            String triesString = entry[1].trim();
            try {
                id = new ResourceLocation(idString);
            }
            catch (Exception ignore) {
                continue;
            }
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(id);
            if (item == null) continue;
            try {
                tries = Integer.parseInt(triesString);
            }
            catch (Exception ignore) {
                continue;
            }
            if (tries <= 0) continue;
            map.put(item, tries);
        }
        return map;
    }

    private static int getSpinsForCurrencyItem(Item item) {
        Map<Item, Integer> currencies = FrogBonanzaBlockEntity.parseBonanzaCurrencies(CompanionsConfig.BONANZA_CURRENCY_TYPES);
        return currencies.getOrDefault(item, 0);
    }

    public double getTick(Object o) {
        return RenderUtils.getCurrentTick();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "coin_controller", state -> PlayState.STOP).triggerableAnim("coin", COIN)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "lever_controller", state -> PlayState.STOP).triggerableAnim("lever", LEVER)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private record TeddyDrop(String id, float chance, int min, int max) {
    }

    private record SkullDropEntities(String id, int amount) {
    }

    private static class BonanzaTnt
    extends PrimedTnt {
        public BonanzaTnt(Level level, double x, double y, double z, LivingEntity owner) {
            super(level, x, y, z, owner);
        }

        protected void m_32103_() {
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 16.0f), this.m_20189_(), 4.0f, Level.ExplosionInteraction.NONE);
        }
    }
}

