/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.common.tesla.TeslaConnectionManager;
import dev.xylonity.companions.common.tesla.behaviour.DefaultAttackBehaviour;
import dev.xylonity.companions.common.util.interfaces.ITeslaNodeBehaviour;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtils;

public abstract class AbstractTeslaBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final TeslaConnectionManager connectionManager = TeslaConnectionManager.getInstance();
    public int tickCount = 0;
    public int activationTick = 0;
    public int cycleCounter = -1;
    protected boolean pendingRemoval = false;
    protected boolean receivesGenerator = false;
    protected int distance = 0;
    protected boolean isActive = false;
    protected UUID ownerUUID;
    protected ITeslaNodeBehaviour defaultAttackBehaviour = new DefaultAttackBehaviour();

    public AbstractTeslaBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public TeslaConnectionManager.ConnectionNode asConnectionNode() {
        ResourceLocation dimension = this.m_58904_() != null ? this.m_58904_().m_46472_().m_135782_() : new ResourceLocation("overworld");
        return TeslaConnectionManager.ConnectionNode.forBlock(this.m_58899_(), dimension);
    }

    public void onLoad() {
        super.onLoad();
        TeslaConnectionManager.getInstance().registerBlockEntity(this);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        tag.m_128437_("OutgoingConnections", 10).forEach(t -> TeslaConnectionManager.getInstance().addConnection(this.asConnectionNode(), TeslaConnectionManager.ConnectionNode.deserialize((CompoundTag)t), true));
        this.tickCount = tag.m_128451_("TickCount");
        this.isActive = tag.m_128471_("IsActive");
        int n = this.activationTick = tag.m_128441_("ActivationTick") ? tag.m_128451_("ActivationTick") : 0;
        if (this.cycleCounter >= 0) {
            tag.m_128405_("CycleCounter", this.cycleCounter);
        }
        this.receivesGenerator = tag.m_128471_("ReceivesGenerator");
        this.setDistance(tag.m_128451_("Distance"));
        this.setAnimationStartTick(tag.m_128451_("AnimationTick"));
        if (tag.m_128441_("OwnerUUID")) {
            this.setOwnerUUID(tag.m_128342_("OwnerUUID"));
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        ListTag outgoing = new ListTag();
        this.connectionManager.getOutgoing(this.asConnectionNode()).forEach(node -> outgoing.add((Object)node.serialize()));
        tag.m_128365_("OutgoingConnections", (Tag)outgoing);
        tag.m_128405_("TickCount", this.tickCount);
        tag.m_128379_("IsActive", this.isActive);
        tag.m_128405_("ActivationTick", this.activationTick);
        tag.m_128405_("CycleCounter", this.cycleCounter);
        tag.m_128379_("ReceivesGenerator", this.receivesGenerator);
        tag.m_128405_("Distance", this.distance);
        tag.m_128405_("AnimationTick", this.getAnimationStartTick());
        if (this.getOwnerUUID() != null) {
            tag.m_128362_("OwnerUUID", this.getOwnerUUID());
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public double getTick(Object o) {
        return RenderUtils.getCurrentTick();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.tickCount = tag.m_128451_("TickCount");
        this.isActive = tag.m_128471_("IsActive");
        this.distance = tag.m_128451_("Distance");
        this.setAnimationStartTick(tag.m_128451_("AnimationTick"));
        this.cycleCounter = tag.m_128451_("CycleCounter");
        if (this.getOwnerUUID() != null) {
            this.setOwnerUUID(tag.m_128342_("OwnerUUID"));
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("TickCount", this.tickCount);
        tag.m_128379_("IsActive", this.isActive);
        tag.m_128405_("Distance", this.distance);
        tag.m_128405_("AnimationTick", this.getAnimationStartTick());
        tag.m_128405_("CycleCounter", this.cycleCounter);
        if (tag.m_128441_("OwnerUUID")) {
            tag.m_128362_("OwnerUUID", this.getOwnerUUID());
        }
        return tag;
    }

    public void sync() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ClientboundBlockEntityDataPacket pkt = ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
        ChunkPos chunkPos = new ChunkPos(this.f_58858_);
        serverLevel.m_7726_().f_8325_.m_183262_(chunkPos, false).forEach(arg_0 -> AbstractTeslaBlockEntity.lambda$sync$2((Packet)pkt, arg_0));
    }

    public boolean isPendingRemoval() {
        return this.pendingRemoval;
    }

    public void setReceivesGenerator(boolean flag) {
        this.receivesGenerator = flag;
    }

    public boolean isReceivesGenerator() {
        return this.receivesGenerator;
    }

    public void setAnimationStartTick(int tick) {
        this.activationTick = tick;
    }

    public void startCycle() {
        this.cycleCounter = 0;
        this.m_6596_();
    }

    public int getAnimationStartTick() {
        return this.activationTick;
    }

    public boolean hasConcurrentPower() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean canConnectToOtherModules() {
        return true;
    }

    @NotNull
    public abstract Vec3 electricalChargeOriginOffset();

    @NotNull
    public abstract Vec3 electricalChargeEndOffset();

    public boolean handleNodeSelection(TeslaConnectionManager.ConnectionNode thisNode, TeslaConnectionManager.ConnectionNode nodeToConnect, @Nullable UseOnContext ctx, Player player) {
        this.connectionManager.addConnection(thisNode, nodeToConnect);
        return true;
    }

    public boolean handleNodeRemoval(TeslaConnectionManager.ConnectionNode thisNode, TeslaConnectionManager.ConnectionNode nodeToConnect, @Nullable UseOnContext ctx, Player player) {
        this.connectionManager.removeConnection(thisNode, nodeToConnect);
        return true;
    }

    private static /* synthetic */ void lambda$sync$2(Packet pkt, ServerPlayer p) {
        p.f_8906_.m_9829_(pkt);
    }
}

