/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.projectile.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.xylonity.companions.client.projectile.model.IceShardBigModel;
import dev.xylonity.companions.common.entity.projectile.BigIceShardProjectile;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class IceShardBigRenderer
extends GeoEntityRenderer<BigIceShardProjectile> {
    public IceShardBigRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new IceShardBigModel());
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull BigIceShardProjectile animatable) {
        return new ResourceLocation("companions", "textures/entity/ice_shard_big.png");
    }

    protected void applyRotations(BigIceShardProjectile entity, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks) {
        Vec3 velocity = entity.m_20184_();
        if (velocity.m_82556_() < 1.0E-7) {
            super.applyRotations((Entity)entity, poseStack, ageInTicks, rotationYaw, partialTicks);
            return;
        }
        Vector3f velocityVec = new Vector3f((float)velocity.f_82479_, (float)velocity.f_82480_, (float)velocity.f_82481_);
        velocityVec.normalize();
        Vector3f defaultForward = new Vector3f(0.0f, 0.0f, 1.0f);
        float dot = defaultForward.dot((Vector3fc)velocityVec);
        dot = Math.max(-1.0f, Math.min(1.0f, dot));
        float angle = (float)Math.acos(dot);
        Vector3f axis = defaultForward.cross((Vector3fc)velocityVec);
        if (axis.length() < 1.0E-4f) {
            axis.set(0.0f, 1.0f, 0.0f);
        } else {
            axis.normalize();
        }
        Quaternionf rotationQuat = new Quaternionf().fromAxisAngleRad((Vector3fc)axis, angle);
        poseStack.m_252781_(rotationQuat);
        super.applyRotations((Entity)entity, poseStack, ageInTicks, rotationYaw, partialTicks);
    }
}

