/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.projectile.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.xylonity.companions.client.projectile.model.FireMarkRingModel;
import dev.xylonity.companions.common.entity.projectile.FireMarkRingProjectile;
import dev.xylonity.companions.config.CompanionsConfig;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class FireMarkRingRenderer
extends GeoEntityRenderer<FireMarkRingProjectile> {
    private static final float MODEL_ORIGINAL_SIZE = 2.5f;

    public FireMarkRingRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new FireMarkRingModel());
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull FireMarkRingProjectile animatable) {
        return new ResourceLocation("companions", "textures/entity/fire_mark_ring.png");
    }

    public RenderType getRenderType(FireMarkRingProjectile animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_110473_((ResourceLocation)this.getTextureLocation(animatable));
    }

    public void render(@NotNull FireMarkRingProjectile entity, float entityYaw, float partialTick, PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        float desiredRadius = (float)CompanionsConfig.FIRE_MARK_EFFECT_RADIUS;
        float scale = desiredRadius / 2.5f;
        poseStack.m_85841_(scale, scale, scale);
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

