/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.projectile.model;

import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import dev.xylonity.companions.common.entity.projectile.SoulMageBookEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;

public class SoulMageBookModel
extends GeoModel<SoulMageBookEntity> {
    private float currentBookYaw = 0.0f;

    public ResourceLocation getModelResource(SoulMageBookEntity animatable) {
        return new ResourceLocation("companions", "geo/soul_mage_book.geo.json");
    }

    public ResourceLocation getTextureResource(SoulMageBookEntity animatable) {
        return new ResourceLocation("companions", "textures/entity/soul_mage_book.png");
    }

    public void setCustomAnimations(SoulMageBookEntity animatable, long instanceId, AnimationState<SoulMageBookEntity> animationState) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        CoreGeoBone mainB = this.getAnimationProcessor().getBone("book2");
        if (mainB == null) {
            return;
        }
        float targetYaw = 0.0f;
        Entity entity = animatable.m_19749_();
        if (entity instanceof SoulMageEntity) {
            SoulMageEntity mage = (SoulMageEntity)entity;
            Vec3 diff = mage.m_20182_().m_82546_(animatable.m_20182_());
            targetYaw = (float)(Math.atan2(diff.f_82481_, diff.f_82479_) * 57.29577951308232) - 90.0f;
            float oscillation = (float)(Math.sin((double)animatable.f_19797_ * 0.05) * 5.0);
            targetYaw += oscillation;
        }
        float angleDiff = this.wrapDegrees(targetYaw - this.currentBookYaw);
        this.currentBookYaw += angleDiff * 0.005f;
        mainB.setRotY((float)Math.toRadians(this.currentBookYaw));
    }

    private float wrapDegrees(float angle) {
        if ((angle %= 360.0f) >= 180.0f) {
            angle -= 360.0f;
        }
        if (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public ResourceLocation getAnimationResource(SoulMageBookEntity animatable) {
        return new ResourceLocation("companions", "animations/soul_mage_book.animation.json");
    }
}

