/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

public class ManagedTextComponent
extends AbstractManagedData<Component> {
    private Component value;
    protected Function<Component, Component> validator = null;

    public ManagedTextComponent(String name, @Nullable Component defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
    }

    public ManagedTextComponent(String name, DataFlags ... flags) {
        this(name, (Component)null, flags);
    }

    public Component set(@Nullable Component value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            Component prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    @Nullable
    public Component get() {
        return this.value;
    }

    public ManagedTextComponent setValidator(Function<Component, Component> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeBoolean(this.value != null);
        if (this.value != null) {
            output.writeTextComponent(this.value);
        }
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readBoolean() ? input.readTextComponent() : null;
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(CompoundTag compound) {
        if (this.value != null) {
            compound.m_128359_(this.name, Component.Serializer.m_130703_((Component)this.value));
        }
    }

    @Override
    public void fromNBT(CompoundTag compound) {
        this.value = compound.m_128441_(this.name) ? Component.Serializer.m_130701_((String)compound.m_128461_(this.name)) : null;
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + this.value + "]";
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean notNull() {
        return this.value != null;
    }
}

