/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.mobcompack.entity.bop;

import com.cartoonishvillain.mobcompack.Register;
import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.loading.FMLLoader;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Jaws
extends Monster
implements GeoEntity {
    private AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> CHARGE = SynchedEntityData.m_135353_(Jaws.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STUN = SynchedEntityData.m_135353_(Jaws.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CHARGEJUMP = SynchedEntityData.m_135353_(Jaws.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final RawAnimation JUMP = RawAnimation.begin().thenPlay("jump");
    private static final RawAnimation CHARGEANIM = RawAnimation.begin().thenPlay("charge");
    private static final RawAnimation STUNANIM = RawAnimation.begin().thenPlay("stun");
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");

    public Jaws(EntityType<? extends Monster> p_33588_, Level p_33589_) {
        super(p_33588_, p_33589_);
        this.f_21342_ = new JawsMovementControl(this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHARGE, (Object)0);
        this.f_19804_.m_135372_(STUN, (Object)0);
        this.f_19804_.m_135372_(CHARGEJUMP, (Object)false);
    }

    public void m_7380_(CompoundTag p_21484_) {
        super.m_7380_(p_21484_);
        p_21484_.m_128405_("charge", this.getCharge());
        p_21484_.m_128405_("stun", this.getCharge());
        p_21484_.m_128379_("cjump", this.getChargeJumping());
    }

    public void m_7378_(CompoundTag p_21450_) {
        super.m_7378_(p_21450_);
        this.setCharge(p_21450_.m_128451_("charge"));
        this.setStun(p_21450_.m_128451_("stun"));
        this.setChargeJumping(p_21450_.m_128471_("cjump"));
    }

    public int getCharge() {
        return (Integer)this.f_19804_.m_135370_(CHARGE);
    }

    public int getStun() {
        return (Integer)this.f_19804_.m_135370_(STUN);
    }

    public boolean getChargeJumping() {
        return (Boolean)this.f_19804_.m_135370_(CHARGEJUMP);
    }

    public void setCharge(int count) {
        this.f_19804_.m_135381_(CHARGE, (Object)count);
    }

    public void setStun(int count) {
        this.f_19804_.m_135381_(STUN, (Object)count);
    }

    public void setChargeJumping(boolean chargeJumping) {
        this.f_19804_.m_135381_(CHARGEJUMP, (Object)chargeJumping);
    }

    public boolean m_5825_() {
        return true;
    }

    protected int m_5639_(float p_21237_, float p_21238_) {
        return 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new JawsTargetingGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new JawsRandomDirectionGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new JawsJumpController(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::shouldAttack));
    }

    public boolean shouldAttack(@Nullable LivingEntity entity) {
        return entity instanceof Player && entity.m_20270_((Entity)this) < 32.0f;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21133_(Attributes.f_22277_) < 32.0) {
            double num = 32.0 - this.m_21133_(Attributes.f_22277_);
            this.m_21051_(Attributes.f_22277_).m_22125_(new AttributeModifier("rangeincrease", num, AttributeModifier.Operation.ADDITION));
        }
        if (this.getStun() > 0) {
            this.setStun(this.getStun() - 1);
        }
        if (this.m_20096_() && this.getChargeJumping()) {
            this.setChargeJumping(false);
        }
    }

    public void m_142687_(Entity.RemovalReason p_149847_) {
        super.m_142687_(p_149847_);
    }

    public void m_6667_(DamageSource p_21014_) {
        super.m_6667_(p_21014_);
    }

    public static AttributeSupplier.Builder customAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.9).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    public boolean m_7327_(Entity p_21372_) {
        if (!this.m_20096_()) {
            return super.m_7327_(p_21372_);
        }
        return false;
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return SoundEvents.f_12386_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12385_;
    }

    public void m_7334_(Entity p_21294_) {
        super.m_7334_(p_21294_);
        if (!this.m_9236_().f_46443_ && this.getStun() <= 0 && p_21294_ instanceof LivingEntity && Objects.equals(this.m_5448_(), p_21294_) && !this.m_20096_() && p_21294_.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), this.getAttackDamage())) {
            this.m_19970_((LivingEntity)this, p_21294_);
        }
    }

    protected void m_6731_(LivingEntity p_21246_) {
        super.m_6731_(p_21246_);
        if (this.getChargeJumping()) {
            this.setStun(50);
        }
    }

    protected int getJumpDelay() {
        return 10 + this.m_9236_().f_46441_.m_188503_(2);
    }

    protected SoundEvent getJumpSound() {
        return this.f_19796_.m_188503_(50) == 0 ? (SoundEvent)Register.SPRING.get() : SoundEvents.f_11865_;
    }

    private PlayState predicate(AnimationState<Jaws> event) {
        if (!this.m_20096_()) {
            return event.setAndContinue(JUMP);
        }
        if (this.getCharge() > 0) {
            return event.setAndContinue(CHARGEANIM);
        }
        if (this.getStun() > 0) {
            return event.setAndContinue(STUNANIM);
        }
        return event.setAndContinue(IDLE);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "jawsController", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    private static class JawsMovementControl
    extends MoveControl {
        private float yRot;
        private int ticksUntilJump;
        private final Jaws jaws;
        private boolean jumpOften;

        public JawsMovementControl(Jaws jaws) {
            super((Mob)jaws);
            this.jaws = jaws;
            this.yRot = 180.0f * jaws.m_146908_() / (float)Math.PI;
        }

        public void setDirection(float targetYaw, boolean jumpOften) {
            this.yRot = targetYaw;
            this.jumpOften = jumpOften;
        }

        public void move(double speed) {
            this.f_24978_ = speed;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            float lavaModifier = 0.0f;
            if (this.jaws.m_20077_()) {
                lavaModifier = 3.5f;
            }
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.f_24974_.m_20096_() || this.f_24974_.m_20077_()) {
                    this.f_24974_.m_21564_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                    if (this.ticksUntilJump-- <= 0) {
                        this.ticksUntilJump = this.jaws.m_5448_() != null ? this.jaws.getJumpDelay() : this.jaws.getJumpDelay() * 3;
                        if (!this.jaws.m_9236_().f_46443_ && this.jaws.getStun() <= 0) {
                            boolean check = false;
                            int chance = this.jaws.m_9236_().f_46441_.m_188503_(5);
                            float distance = 0.0f;
                            float distanceMultiplier = 1.0f;
                            if (this.jaws.m_5448_() != null) {
                                distance = this.jaws.m_20270_((Entity)this.jaws.m_5448_());
                                if (distance > 27.0f) {
                                    distanceMultiplier = 2.0f;
                                } else if (distance > 22.0f) {
                                    distanceMultiplier = 1.8f;
                                } else if (distance > 17.0f) {
                                    distanceMultiplier = 1.6f;
                                } else if (distance > 12.0f) {
                                    distanceMultiplier = 1.4f;
                                } else if (distance > 7.0f) {
                                    distanceMultiplier = 1.2f;
                                }
                            }
                            if (this.jaws.getCharge() > 0) {
                                this.jaws.setCharge(this.jaws.getCharge() - 1);
                                check = true;
                            }
                            if (this.jaws.getCharge() >= 0 && check && this.jaws.getCharge() == 0 && this.jaws.m_5448_() != null) {
                                this.jaws.f_21342_.m_6849_(this.jaws.m_5448_().m_20185_(), this.jaws.m_5448_().m_20186_(), this.jaws.m_5448_().m_20189_(), 1.5);
                                Vec3 goalPosition = new Vec3(this.jaws.f_21342_.m_25000_(), this.jaws.f_21342_.m_25001_(), this.jaws.f_21342_.m_25002_());
                                Vec3 directionVector = goalPosition.m_82546_(this.jaws.m_146892_()).m_82541_();
                                Vec3 yeetVector = new Vec3(directionVector.m_7096_() * 2.0 * (double)distanceMultiplier, (double)(0.5f + lavaModifier), directionVector.f_82481_ * 2.0 * (double)distanceMultiplier);
                                this.jaws.m_20256_(yeetVector);
                                this.jaws.m_5496_(this.jaws.getJumpSound(), this.jaws.m_6121_(), 1.0f);
                                this.jaws.m_6853_(false);
                                this.jaws.m_21569_().m_24901_();
                                this.jaws.setChargeJumping(true);
                                if (!FMLLoader.isProduction()) {
                                    this.jaws.m_5448_().m_213846_((Component)Component.m_237113_((String)"Charge jump"));
                                }
                            } else if (this.jaws.m_5448_() != null && this.jaws.getCharge() <= 0) {
                                if (!FMLLoader.isProduction()) {
                                    this.jaws.m_5448_().m_213846_((Component)Component.m_237113_((String)"===(Debug)==="));
                                    this.jaws.m_5448_().m_213846_((Component)Component.m_237113_((String)("Chance: " + chance)));
                                    this.jaws.m_5448_().m_213846_((Component)Component.m_237113_((String)("Distance: " + distance)));
                                }
                                if (chance == 0 && distance > 8.0f) {
                                    this.jaws.setCharge(1);
                                } else {
                                    this.jaws.f_21342_.m_6849_(this.jaws.m_5448_().m_20185_(), this.jaws.m_5448_().m_20186_(), this.jaws.m_5448_().m_20189_(), 1.5);
                                    Vec3 goalPosition = new Vec3(this.jaws.f_21342_.m_25000_(), this.jaws.f_21342_.m_25001_(), this.jaws.f_21342_.m_25002_());
                                    Vec3 directionVector = goalPosition.m_82546_(this.jaws.m_146892_()).m_82541_();
                                    Vec3 yeetVector = new Vec3(directionVector.f_82479_ * (double)1.1f * (double)distanceMultiplier, (double)(0.45f + lavaModifier), directionVector.f_82481_ * (double)1.1f * (double)distanceMultiplier);
                                    this.jaws.m_20256_(yeetVector);
                                    this.jaws.m_5496_(this.jaws.getJumpSound(), this.jaws.m_6121_(), 1.0f);
                                    this.jaws.m_6853_(false);
                                    this.jaws.m_21569_().m_24901_();
                                }
                            } else if (this.jaws.getCharge() <= 0) {
                                double radDirection = Math.toRadians(this.jaws.m_146908_() + 90.0f);
                                Vec3 yeetVector = new Vec3(Math.cos(radDirection), (double)(0.4f + lavaModifier), Math.sin(radDirection));
                                this.jaws.m_20256_(yeetVector);
                                this.jaws.m_5496_(this.jaws.getJumpSound(), this.jaws.m_6121_(), 1.0f);
                                this.jaws.m_6853_(false);
                                this.jaws.m_21569_().m_24901_();
                            }
                        }
                    } else {
                        this.jaws.f_20900_ = 0.0f;
                        this.jaws.f_20902_ = 0.0f;
                        this.f_24974_.m_7910_(0.0f);
                    }
                } else {
                    this.f_24974_.m_21564_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                }
            }
        }
    }

    static class JawsTargetingGoal
    extends Goal {
        private final Jaws jaws;

        public JawsTargetingGoal(Jaws p_33648_) {
            this.jaws = p_33648_;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.jaws.m_5448_();
            if (livingentity == null) {
                return false;
            }
            return this.jaws.m_6779_(livingentity) && this.jaws.m_21566_() instanceof JawsMovementControl;
        }

        public void m_8056_() {
            super.m_8056_();
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.jaws.m_5448_();
            if (livingentity == null) {
                return false;
            }
            return this.jaws.m_6779_(livingentity);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.jaws.m_5448_();
            if (livingentity != null) {
                this.jaws.m_21391_((Entity)livingentity, 10.0f, 10.0f);
            }
            ((JawsMovementControl)this.jaws.m_21566_()).setDirection(this.jaws.m_146908_(), true);
        }
    }

    static class JawsRandomDirectionGoal
    extends Goal {
        private final Jaws jaws;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public JawsRandomDirectionGoal(Jaws p_33679_) {
            this.jaws = p_33679_;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.jaws.m_5448_() == null && (this.jaws.m_20096_() || this.jaws.m_20069_() || this.jaws.m_20077_() || this.jaws.m_21023_(MobEffects.f_19620_)) && this.jaws.m_21566_() instanceof JawsMovementControl;
        }

        public void m_8037_() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = this.m_183277_(40 + this.jaws.m_217043_().m_188503_(40));
                this.chosenDegrees = this.jaws.m_217043_().m_188503_(360);
            }
            if (!this.jaws.m_9236_().f_46443_) {
                this.jaws.m_146922_(this.chosenDegrees);
            }
            ((JawsMovementControl)this.jaws.m_21566_()).setDirection(this.chosenDegrees, false);
        }
    }

    static class JawsJumpController
    extends Goal {
        private final Jaws jaws;

        public JawsJumpController(Jaws p_33660_) {
            this.jaws = p_33660_;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.jaws.m_20159_();
        }

        public void m_8037_() {
            ((JawsMovementControl)this.jaws.m_21566_()).move(1.5);
        }
    }
}

