/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.handler;

import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.mysticalagriculture.api.tinkering.ITinkerable;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.init.ModEnchantments;
import com.blakebr0.mysticalagriculture.init.ModItems;
import java.util.Collection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class MobDropHandler {
    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        Player player;
        ItemStack held;
        Item item;
        LivingEntity entity = event.getEntity();
        Level level = entity.m_20193_();
        if (!level.m_46469_().m_46207_(GameRules.f_46135_)) {
            return;
        }
        Collection drops = event.getDrops();
        Entity attacker = event.getSource().m_7639_();
        double inferiumDropChance = (Double)ModConfigs.INFERIUM_DROP_CHANCE.get();
        if (entity instanceof PathfinderMob && Math.random() < inferiumDropChance) {
            drops.add(new ItemEntity(level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), new ItemStack((ItemLike)ModItems.INFERIUM_ESSENCE.get())));
        }
        if (attacker instanceof Player && (item = (held = (player = (Player)attacker).m_21205_()).m_41720_()) instanceof ITinkerable) {
            int enlightenmentLevel;
            ItemStack stack;
            boolean dragonDropsEssence;
            ItemStack stack2;
            ITinkerable tinkerable = (ITinkerable)item;
            boolean witherDropsEssence = (Boolean)ModConfigs.WITHER_DROPS_ESSENCE.get();
            if (witherDropsEssence && entity instanceof WitherBoss && !(stack2 = MobDropHandler.getEssenceForTinkerable(tinkerable, 1, 3)).m_41619_()) {
                drops.add(new ItemEntity(level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack2));
            }
            if ((dragonDropsEssence = ((Boolean)ModConfigs.DRAGON_DROPS_ESSENCE.get()).booleanValue()) && entity instanceof EnderDragon && !(stack = MobDropHandler.getEssenceForTinkerable(tinkerable, 2, 4)).m_41619_()) {
                drops.add(new ItemEntity(level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack));
            }
            if ((enlightenmentLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.MYSTICAL_ENLIGHTENMENT.get()), (ItemStack)held)) > 0) {
                boolean dragonDropsCognizant;
                boolean witherDropsCognizant = (Boolean)ModConfigs.WITHER_DROPS_COGNIZANT.get();
                if (witherDropsCognizant && entity instanceof WitherBoss) {
                    ItemStack stack3 = new ItemStack((ItemLike)ModItems.COGNIZANT_DUST.get(), 4 + (enlightenmentLevel - 1));
                    drops.add(new ItemEntity(level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack3));
                }
                if ((dragonDropsCognizant = ((Boolean)ModConfigs.DRAGON_DROPS_COGNIZANT.get()).booleanValue()) && entity instanceof EnderDragon) {
                    ItemStack stack4 = new ItemStack((ItemLike)ModItems.COGNIZANT_DUST.get(), 4 + enlightenmentLevel * 2);
                    drops.add(new ItemEntity(level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack4));
                }
            }
        }
    }

    private static ItemStack getEssenceForTinkerable(ITinkerable tinkerable, int min, int max) {
        return switch (tinkerable.getTinkerableTier()) {
            case 1 -> new ItemStack((ItemLike)ModItems.INFERIUM_ESSENCE.get(), Utils.randInt((int)min, (int)max));
            case 2 -> new ItemStack((ItemLike)ModItems.PRUDENTIUM_ESSENCE.get(), Utils.randInt((int)min, (int)max));
            case 3 -> new ItemStack((ItemLike)ModItems.TERTIUM_ESSENCE.get(), Utils.randInt((int)min, (int)max));
            case 4 -> new ItemStack((ItemLike)ModItems.IMPERIUM_ESSENCE.get(), Utils.randInt((int)min, (int)max));
            case 5 -> new ItemStack((ItemLike)ModItems.SUPREMIUM_ESSENCE.get(), Utils.randInt((int)min, (int)max));
            default -> ItemStack.f_41583_;
        };
    }
}

