/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.data.recipe;

import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.lib.LazyIngredient;
import com.blakebr0.mysticalagriculture.crafting.condition.CropEnabledCondition;
import com.blakebr0.mysticalagriculture.crafting.condition.CropHasMaterialCondition;
import com.blakebr0.mysticalagriculture.crafting.ingredient.CropComponentIngredient;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.registries.ForgeRegistries;

public class InfusionRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final JsonArray conditions = new JsonArray();
    private Ingredient input = Ingredient.f_43901_;

    public InfusionRecipeBuilder(ItemLike output, int count) {
        this.result = output.m_5456_();
        this.count = count;
    }

    public void addIngredient(Ingredient ingredient) {
        this.ingredients.add(ingredient);
    }

    public void addCondition(JsonObject condition) {
        this.conditions.add((JsonElement)condition);
    }

    public static InfusionRecipeBuilder newSeedRecipe(Crop crop) {
        InfusionRecipeBuilder builder = new InfusionRecipeBuilder((ItemLike)crop.getSeedsItem(), 1);
        CropComponentIngredient essence = new CropComponentIngredient(crop, CropComponentIngredient.ComponentType.ESSENCE);
        CropComponentIngredient seed = new CropComponentIngredient(crop, CropComponentIngredient.ComponentType.SEED);
        CropComponentIngredient material = new CropComponentIngredient(crop, CropComponentIngredient.ComponentType.MATERIAL);
        builder.input = seed;
        builder.addIngredient(material);
        builder.addIngredient(essence);
        builder.addIngredient(material);
        builder.addIngredient(essence);
        builder.addIngredient(material);
        builder.addIngredient(essence);
        builder.addIngredient(material);
        builder.addIngredient(essence);
        JsonObject condition = new JsonObject();
        condition.addProperty("type", CropEnabledCondition.Serializer.INSTANCE.getID().toString());
        condition.addProperty("crop", crop.getId().toString());
        builder.addCondition(condition);
        condition = new JsonObject();
        condition.addProperty("type", CropHasMaterialCondition.Serializer.INSTANCE.getID().toString());
        condition.addProperty("crop", crop.getId().toString());
        builder.addCondition(condition);
        LazyIngredient ingredient = crop.getLazyIngredient();
        if (ingredient.isTag()) {
            JsonObject tagEmptyCondition = new JsonObject();
            tagEmptyCondition.addProperty("type", TagEmptyCondition.Serializer.INSTANCE.getID().toString());
            tagEmptyCondition.addProperty("tag", ingredient.getId());
            condition = new JsonObject();
            condition.addProperty("type", "forge:not");
            condition.add("value", (JsonElement)tagEmptyCondition);
            builder.addCondition(condition);
        }
        return builder;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.result, this.count, this.input, this.ingredients, this.conditions));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final Ingredient input;
        private final List<Ingredient> ingredients;
        private final JsonArray conditions;

        public Result(ResourceLocation id, Item result, int count, Ingredient input, List<Ingredient> ingredients, JsonArray conditions) {
            this.id = id;
            this.result = result;
            this.count = count;
            this.input = input;
            this.ingredients = ingredients;
            this.conditions = conditions;
        }

        public void m_7917_(JsonObject json) {
            json.add("conditions", (JsonElement)this.conditions);
            json.add("input", this.input.m_43942_());
            JsonArray ingredients = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                ingredients.add(ingredient.m_43942_());
            }
            json.add("ingredients", (JsonElement)ingredients);
            JsonObject result = new JsonObject();
            result.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
            if (this.count > 1) {
                result.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)result);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipeSerializers.INFUSION.get();
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

