/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.util;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.soul.MobSoulType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MobSoulUtils {
    public static CompoundTag makeTag(MobSoulType type) {
        return MobSoulUtils.makeTag(type, type.getSoulRequirement());
    }

    public static CompoundTag makeTag(MobSoulType type, double souls) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Type", type.getId().toString());
        nbt.m_128347_("Souls", Math.min(souls, type.getSoulRequirement()));
        return nbt;
    }

    public static ItemStack getSoulJar(MobSoulType type, double souls, Item item) {
        CompoundTag nbt = MobSoulUtils.makeTag(type, souls);
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.m_41751_(nbt);
        return stack;
    }

    public static ItemStack getFilledSoulJar(MobSoulType type, Item item) {
        CompoundTag nbt = MobSoulUtils.makeTag(type);
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.m_41751_(nbt);
        return stack;
    }

    public static MobSoulType getType(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_("Type")) {
            String type = nbt.m_128461_("Type");
            return MysticalAgricultureAPI.getMobSoulTypeRegistry().getMobSoulTypeById(new ResourceLocation(type));
        }
        return null;
    }

    public static double getSouls(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_("Souls")) {
            return nbt.m_128459_("Souls");
        }
        return 0.0;
    }

    public static boolean canAddTypeToJar(ItemStack stack, MobSoulType type) {
        MobSoulType containedType = MobSoulUtils.getType(stack);
        return containedType == null || containedType == type;
    }

    public static boolean isJarFull(ItemStack stack) {
        MobSoulType type = MobSoulUtils.getType(stack);
        return type != null && MobSoulUtils.getSouls(stack) >= type.getSoulRequirement();
    }

    public static double addSoulsToJar(ItemStack stack, MobSoulType type, double amount) {
        CompoundTag nbt;
        MobSoulType containedType = MobSoulUtils.getType(stack);
        if (containedType != null && containedType != type) {
            return amount;
        }
        double requirement = type.getSoulRequirement();
        if (containedType == null) {
            CompoundTag nbt2 = MobSoulUtils.makeTag(type, amount);
            stack.m_41751_(nbt2);
            return Math.max(0.0, amount - requirement);
        }
        double souls = MobSoulUtils.getSouls(stack);
        if (souls < requirement && (nbt = stack.m_41783_()) != null) {
            double newSouls = Math.min(requirement, souls + amount);
            nbt.m_128347_("Souls", newSouls);
            return Math.max(0.0, amount - (newSouls - souls));
        }
        return amount;
    }
}

