/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.packs;

import dev.obscuria.fragmentum.Fragmentum;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.flag.FeatureFlagSet;
import org.jetbrains.annotations.Nullable;

public final class FragmentumLayer {

    public static final class Resources
    extends PathPackResources {
        private static final ResourceLocation ICON = Fragmentum.key("fragmentum_layer.png");

        public Resources(String packId, Path root) {
            super(packId, root, true);
        }

        @Nullable
        public IoSupplier<InputStream> m_8017_(String ... path) {
            String fileName = String.join((CharSequence)"/", path);
            if (!fileName.equals("pack.png")) {
                return super.m_8017_(path);
            }
            ResourceManager manager = Minecraft.m_91087_().m_91098_();
            Optional resource = manager.m_213713_(ICON);
            if (resource.isEmpty()) {
                return null;
            }
            return () -> ((Resource)((Resource)resource.orElseThrow())).m_215507_();
        }
    }

    public record Source(Path directory, PackType type) implements RepositorySource
    {
        public static final Pack.Info CLIENT_METADATA;
        public static final Pack.Info SERVER_METADATA;

        public static Source create(PackType type) {
            Path root = Path.of(System.getProperty("user.dir"), new String[0]).toAbsolutePath().normalize();
            Path directory = root.resolve("config/fragmentum");
            Source.createDirectories(directory);
            return new Source(directory, type);
        }

        public void m_7686_(Consumer<Pack> consumer) {
            Pack.Info metadata = this.type == PackType.CLIENT_RESOURCES ? CLIENT_METADATA : SERVER_METADATA;
            consumer.accept(Pack.m_245512_((String)"generated/fragmentum_layer", (Component)Component.m_237113_((String)"Fragmentum Layer"), (boolean)true, packId -> new Resources(packId, this.directory), (Pack.Info)metadata, (PackType)this.type, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_));
        }

        private static void createDirectories(Path directory) {
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            catch (IOException exception) {
                Fragmentum.LOGGER.error("Failed to create directories: {}", (Object)directory, (Object)exception);
            }
        }

        static {
            int clientVersion = SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES);
            int serverVersion = SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA);
            CLIENT_METADATA = new Pack.Info((Component)Component.m_237113_((String)"Global resources"), clientVersion, FeatureFlagSet.m_246902_());
            SERVER_METADATA = new Pack.Info((Component)Component.m_237113_((String)"Global configurations"), serverVersion, FeatureFlagSet.m_246902_());
        }
    }
}

