/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.network;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.PluginManager;
import com.misterpemodder.shulkerboxtooltip.impl.config.ConfigurationHandler;
import com.misterpemodder.shulkerboxtooltip.impl.network.ProtocolVersion;
import com.misterpemodder.shulkerboxtooltip.impl.network.RegistrationChangeType;
import com.misterpemodder.shulkerboxtooltip.impl.network.forge.ClientNetworkingImpl;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.C2SMessages;
import dev.architectury.injectables.annotations.ExpectPlatform;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientNetworking {
    @Nullable
    public static ProtocolVersion serverProtocolVersion;

    public static void onJoinServer(Minecraft client) {
        client.execute(() -> {
            PluginManager.loadColors();
            PluginManager.loadProviders();
        });
        ShulkerBoxTooltip.config = ConfigurationHandler.copyOf(ShulkerBoxTooltip.savedConfig);
        serverProtocolVersion = null;
        if (!Minecraft.m_91087_().m_91091_()) {
            ConfigurationHandler.reinitClientSideSyncedValues(ShulkerBoxTooltip.config);
        }
        C2SMessages.attemptHandshake();
    }

    public static Packet<?> createC2SPacket(ResourceLocation channelId, FriendlyByteBuf buf) {
        return new ServerboundCustomPayloadPacket(channelId, buf);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        ClientNetworkingImpl.init();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerS2CReceiver(ResourceLocation channelId, PacketReceiver receiver) {
        void var1_1;
        ClientNetworkingImpl.registerS2CReceiver(channelId, (PacketReceiver)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void unregisterS2CReceiver(ResourceLocation channelId) {
        ClientNetworkingImpl.unregisterS2CReceiver(channelId);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addRegistrationChangeListener(ResourceLocation channelId, RegistrationChangeListener listener) {
        void var1_1;
        ClientNetworkingImpl.addRegistrationChangeListener(channelId, (RegistrationChangeListener)var1_1);
    }

    @FunctionalInterface
    public static interface RegistrationChangeListener {
        public void onRegistrationChange(RegistrationChangeType var1);
    }

    @FunctionalInterface
    public static interface PacketReceiver {
        public void handle(FriendlyByteBuf var1);
    }
}

