/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.capability.provider;

import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.capabilities.Capabilities;
import com.alrex.parcool.common.capability.stamina.OtherStamina;
import com.alrex.parcool.common.capability.storage.StaminaStorage;
import com.alrex.parcool.config.ParCoolConfig;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class StaminaProvider
implements ICapabilitySerializable<CompoundTag> {
    private final LazyOptional<IStamina> instanceOptional;

    public StaminaProvider(Player player) {
        IStamina instance = player.m_7578_() ? ((IStamina.Type)((Object)ParCoolConfig.Client.StaminaType.get())).newInstance(player) : new OtherStamina(player);
        this.instanceOptional = LazyOptional.of(() -> instance);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction direction) {
        if (capability == Capabilities.STAMINA_CAPABILITY) {
            return this.instanceOptional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return (CompoundTag)new StaminaStorage().writeTag(Capabilities.STAMINA_CAPABILITY, (IStamina)this.instanceOptional.resolve().get(), null);
    }

    public void deserializeNBT(CompoundTag nbt) {
        new StaminaStorage().readTag(Capabilities.STAMINA_CAPABILITY, (IStamina)this.instanceOptional.resolve().get(), null, (Tag)nbt);
    }
}

